%%
%%% jasj.cls (pLaTeX2e)
%%   for the Journal of the Acoustical Society of Japan
%%    by Motoaki Sato (ULS and Company), 2003.
%%     E-mail: teppei@uls.co.jp, http://www.uls.co.jp/
%%%
\newif\if@NTT
\@ifundefined{kanjiskip}{\@NTTtrue
 \let\kanjiskip=\jintercharskip
 \let\xkanjiskip=\jasciikanjiskip
 \let\inhibitglue\relax
%\def\bf{\protect\pdg\protect\pbf}
 }{\@NTTfalse}
\@ifundefined{burasage}{}{\burasage`，=1\burasage`．=1}
\if@NTT
 \NeedsTeXFormat{jLaTeX}
\else
 \NeedsTeXFormat{pLaTeX2e}
\fi
\ProvidesClass{jasj}
%%[2003/02/14-03/03 v1.0 prelease 01 for JASJ]
%%[2003/04/02 v1.0 prelease 04 for JASJ]
%%[2003/08/22 v1.0 prelease 17 for JASJ]
%%[2003/08/26 v1.0 for JASJ]
  [2023/08/01 v1.0 for JASJ]

\def\jasjline@warning{\ClassWarning{jasj}}
\def\jasj@warning{\ClassWarningNoLine{jasj}}

\newdimen\@JQ
 \@JQ=0.7392507pt
\newdimen\@Q
 \@Q=0.71144pt
\newdimen\@EM
 \@EM=.03125em

\def\@TypeofDoc#1{\gdef\@Type@fDoc{#1}}
\def\@Type@fDoc{}

\newif\if@xiiQ \@xiiQtrue
\newif\if@Paper \@Papertrue
\newif\if@xivQ \@xivQfalse
\DeclareOption{Paper}{% 12Q
 \@Papertrue\@xiiQtrue\@TypeofDoc{論文}}
\newif\if@TechnicalReport \@TechnicalReportfalse
\DeclareOption{TechnicalReport}{% 12Q
 \@TechnicalReporttrue\@Paperfalse\@xiiQtrue\@TypeofDoc{技術報告}}
\newif\if@Letter \@Letterfalse
\DeclareOption{Letter}{% 12Q
 \@Lettertrue\@Paperfalse\@xiiQtrue\@TypeofDoc{研究速報}}
\newif\if@ShortNote \@ShortNotefalse
\DeclareOption{ShortNote}{% 12Q
 \@ShortNotetrue\@Paperfalse\@xiiQtrue\@TypeofDoc{寄書}}
\newif\if@General \@Generalfalse
\DeclareOption{GeneralReview}{% ??Q
 \@Generaltrue\@Paperfalse\@TypeofDoc{総説}}% \@xiiQfalse ??
\newif\if@TuningFork \@TuningForkfalse
\DeclareOption{TuningFork}{% 13Q
 \@TuningForktrue\@xivQtrue\@Paperfalse\@xiiQfalse\@TypeofDoc{音叉}}
\newif\if@Feature \@Featurefalse
\DeclareOption{Feature}{% 13Q
 \@Featuretrue\@Paperfalse\@xiiQfalse\@TypeofDoc{小特集}}
\newif\if@Review \@Reviewfalse
\DeclareOption{Review}{% 13Q
 \@Reviewtrue\@Paperfalse\@xiiQfalse}
%% \@TypeofDoc{}(解説/やさしい解説/特別講演/会議報告)
\newif\if@TechPlaza \@TechPlazafalse
\DeclareOption{TechnicalPlaza}{% 13Q
 \@TechPlazatrue\@Paperfalse\@xiiQfalse\@TypeofDoc{技術プラザ}}
\newif\if@Foreword \@Forewordfalse
\DeclareOption{Foreword}{%
 \@Forewordtrue\@xivQtrue\@Paperfalse\@xiiQfalse\@TypeofDoc{巻頭言}}
\newif\if@FwdPres \@FwdPresfalse
\DeclareOption{Foreword*}{% 「会長就任にあたって」など
 \@Forewordtrue\@FwdPrestrue\@xivQtrue\@Paperfalse\@xiiQfalse}% \@TypeofDoc{}
\newif\if@CoffeeBreak \@CoffeeBreakfalse
\DeclareOption{CoffeeBreak}{%
 \@CoffeeBreaktrue\@Paperfalse\@xiiQfalse}% コーヒーブレーク
\newif\if@MemWr\@MemWrfalse
\DeclareOption{MemorialWriting}{%
 \@MemWrtrue\@Paperfalse\@xiiQfalse\@twocolumnfalse}% 追悼文
% \newif\if@english \@englishfalse
% \DeclareOption{english}{\@englishtrue}

\newif\if@Proof \@Prooffalse
\DeclareOption{Proof}{\@Prooftrue}
\newif\if@cameraready \@camerareadyfalse
\DeclareOption{cameraready}{\@camerareadytrue}

\DeclareMathSizes{\@xipt}{\@xipt}{7}{5}% for \author@font
\DeclareMathSizes{8}{8}{5}{5}% for footnote

\newcounter{@paper}
\newcommand{\@ptsize}{}
\newif\if@restonecol
%%% for 2.1.4 and non pLaTeX2e compatibility
\@ifundefined{hour}{}{%
 \hour\time \divide\hour by 60\relax
 \@tempcnta\hour \multiply\@tempcnta 60\relax
 \minute\time \advance\minute-\@tempcnta
}
%\newif\if@stysize \@stysizefalse
\newif\if@enablejfam \@enablejfamtrue
\DeclareOption{a4paper}{\setcounter{@paper}{4}%
  \setlength\paperheight {297mm}
  \setlength\paperwidth  {210mm}}
%\DeclareOption{b5j}{\setcounter{@paper}{4}\@stysizetrue
%  \setlength\paperheight {257mm}
%  \setlength\paperwidth  {182mm}}
\DeclareOption{10pt}{\renewcommand{\@ptsize}{0}}
\DeclareOption{11pt}{\renewcommand{\@ptsize}{1}}
\DeclareOption{12pt}{\renewcommand{\@ptsize}{2}}
\DeclareOption{tombow}{%
  \tombowtrue \tombowdatetrue
  \setlength{\@tombowwidth}{.1\p@}%
  \@bannertoken{%
     \jobname\space:\space\number\year/\number\month/\number\day
      (\number\hour:\number\minute)}
  \maketombowbox}
\DeclareOption{tombo}{%
  \tombowtrue \tombowdatefalse
  \setlength{\@tombowwidth}{.1\p@}%
  \maketombowbox}
\DeclareOption{mentuke}{%
  \tombowtrue \tombowdatefalse
  \setlength{\@tombowwidth}{\z@}%
  \maketombowbox}
\DeclareOption{tate}{%
  \AtBeginDocument{\tate\message{《縦組モード》}%
                   \adjustbaseline}%
}
\DeclareOption{oneside}{\@twosidefalse}
\DeclareOption{twoside}{\@twosidetrue}
\DeclareOption{onecolumn}{\@twocolumnfalse}
\DeclareOption{twocolumn}{\@twocolumntrue}
%\DeclareOption{titlepage}{\@titlepagetrue}
%\DeclareOption{notitlepage}{\@titlepagefalse}
\DeclareOption{leqno}{\input{leqno.clo}}
\DeclareOption{fleqn}{% \input{fleqn.clo}
 \jasj@warning{fleqn is loaded by this class file}}
\DeclareOption{openbib}{%
  \AtEndOfPackage{%
   \renewcommand\@openbib@code{%
      \advance\leftmargin\bibindent
      \itemindent -\bibindent
      \listparindent \itemindent
      \parsep \z@
      }%
   \renewcommand\newblock{\par}}}
\DeclareOption{disablejfam}{\@enablejfamfalse}
\DeclareOption{draft}{\setlength\overfullrule{5pt}}
\DeclareOption{final}{\setlength\overfullrule{0pt}}
\ExecuteOptions{b5paper,10pt,twoside,twocolumn,final}
\ProcessOptions\relax

\if@NTT
\else
\if@cameraready
 \input jasj-cameraready.fd
\else
\DeclareFontShape{JY1}{mc}{m}{n}{%
  <5>     sfixed * [5.1748] min5  %  7Q
  <6>     sfixed * [5.9141] min6  %  8Q
  <7>     sfixed * [7.3926] min7  % 10Q
  <8>     sfixed * [8.1318] min8  % 11Q
  <9>     sfixed * [8.8711] min9  % 12Q
  <10>    sfixed * [9.6104] min10 % 13Q
  <10.95> sfixed * [11.089] min10 % 15Q
  <12>    sfixed * [13.307] min10 % 18Q
  <14.4>  sfixed * [14.785] min10 % 20Q
  <17.28> sfixed * [17.742] min10 % 24Q
  <20.74> sfixed * [20.699] min10 % 28Q
  <24.88> sfixed * [23.656] min10 % 32Q
  <->                       min10 % 14Q, 16Q, 36Q, and so on
}{}
\DeclareFontShape{JY1}{mc}{bx}{n}{%
  <5>     sfixed * [5.1748] goth5
  <6>     sfixed * [5.9141] goth6
  <7>     sfixed * [7.3926] goth7
  <8>     sfixed * [8.1318] goth8
  <9>     sfixed * [8.8711] goth9
  <10>    sfixed * [9.6104] goth10
  <10.95> sfixed * [11.089] goth10
  <12>    sfixed * [13.307] goth10
  <14.4>  sfixed * [14.785] goth10
  <17.28> sfixed * [17.742] goth10
  <20.74> sfixed * [20.699] goth10
  <24.88> sfixed * [23.656] goth10
  <->                       goth10
}{}
\DeclareFontShape{JY1}{gt}{m}{n}{%
  <5>     sfixed * [5.1748] goth5
  <6>     sfixed * [5.9141] goth6
  <7>     sfixed * [7.3926] goth7
  <8>     sfixed * [8.1318] goth8
  <9>     sfixed * [8.8711] goth9
  <10>    sfixed * [9.6104] goth10
  <10.95> sfixed * [11.089] goth10
  <12>    sfixed * [13.307] goth10
  <14.4>  sfixed * [14.785] goth10
  <17.28> sfixed * [17.742] goth10
  <20.74> sfixed * [20.699] goth10
  <24.88> sfixed * [23.656] goth10
  <->                       goth10
}{}
\DeclareFontShape{JY1}{gt}{bx}{n}{%
  <5>     sfixed * [5.1748] goth5
  <6>     sfixed * [5.9141] goth6
  <7>     sfixed * [7.3926] goth7
  <8>     sfixed * [8.1318] goth8
  <9>     sfixed * [8.8711] goth9
  <10>    sfixed * [9.6104] goth10
  <10.95> sfixed * [11.089] goth10
  <12>    sfixed * [13.307] goth10
  <14.4>  sfixed * [14.785] goth10
  <17.28> sfixed * [17.742] goth10
  <20.74> sfixed * [20.699] goth10
  <24.88> sfixed * [23.656] goth10
  <->                       goth10
}{}
\fi
\fi

\DeclareFontShape{JY1}{mc}{m}{it}{<->ssub*mc/m/n}{}
\DeclareFontShape{JY1}{mc}{bx}{it}{<->ssub*gt/m/n}{}
\DeclareFontShape{JY1}{gt}{m}{it}{<->ssub*gt/m/n}{}
\DeclareFontShape{JY1}{gt}{bx}{it}{<->ssub*gt/m/n}{}
\DeclareFontShape{JY1}{mc}{m}{sl}{<->ssub*mc/m/n}{}
\DeclareFontShape{JY1}{mc}{m}{sc}{<->ssub*mc/m/n}{}
\DeclareFontShape{JT1}{mc}{m}{it}{<->ssub*mc/m/n}{}
\DeclareFontShape{JT1}{mc}{bx}{it}{<->ssub*gt/m/n}{}
\DeclareFontShape{JT1}{gt}{m}{it}{<->ssub*gt/m/n}{}
\DeclareFontShape{JT1}{gt}{bx}{it}{<->ssub*gt/m/n}{}
\DeclareFontShape{JT1}{mc}{m}{sl}{<->ssub*mc/m/n}{}
\DeclareFontShape{JT1}{mc}{m}{sc}{<->ssub*mc/m/n}{}

%% original: /usr/local/teTeX/share/texmf/tex/latex/base/ot1cmr.fd [2002/01/21]
\DeclareFontShape{OT1}{cmr}{m}{n}%
     {%
      <-6>cmr5%
      <6-7>cmr6%
      <7-8>cmr7%
      <8-9>cmr8%
      <9-10>cmr9%
      <10-12>cmr10%
      <12-17>cmr12%
      <17->cmr17%
      }{}
\DeclareFontShape{OT1}{cmr}{m}{sl}%
     {%
      <-9>cmsl8%
      <9-10>cmsl9%
      <10-12>cmsl10%
      <12->cmsl12%
      }{}
\DeclareFontShape{OT1}{cmr}{m}{it}%
     {%
      <-8>cmti7%
      <8-9>cmti8%
      <9-10>cmti9%
      <10-12>cmti10%
      <12->cmti12%
      }{}
\DeclareFontShape{OT1}{cmr}{m}{sc}%
     {%
      <->cmcsc10%
      }{}
\DeclareFontShape{OT1}{cmr}{m}{ui}
     {%
      <->cmu10%
      }{}
\DeclareFontShape{OT1}{cmr}{b}{n}
     {%
      <->cmb10%
      }{}
\DeclareFontShape{OT1}{cmr}{bx}{n}
     {%
      <-6>cmbx5%
      <6-7>cmbx6%
      <7-8>cmbx7%
      <8-9>cmbx8%
      <9-10>cmbx9%
      <10-12>cmbx10%
      <12->cmbx12%
      }{}
\DeclareFontShape{OT1}{cmr}{bx}{sl}
     {%
      <->cmbxsl10%
      }{}
\DeclareFontShape{OT1}{cmr}{bx}{it}
     {%
      <->cmbxti10%
      }{}
\DeclareFontShape{OT1}{cmr}{bx}{ui}
     {%
      <->sub*cmr/m/ui
      }{}

\renewcommand{\normalsize}{%
 \@setfontsize\normalsize\@xpt{\if@Foreword 21\@Q\else 20\@Q\fi}%
 \abovedisplayskip .5\Cvs \@plus .25\Cvs \@minus .15\Cvs
 \abovedisplayshortskip \z@ \@plus 1\p@
 \belowdisplayshortskip .3\Cvs \@plus .15\Cvs \@minus .1\Cvs
 \belowdisplayskip \abovedisplayskip
 \let\@listi\@listI}

\if@xiiQ\else
 \if@xivQ
  \fontsize{14\@JQ}{21\@Q}\selectfont
  \setbox0\hbox{\char\euc"A1A1}% "
  \setlength\Cht{\ht0}
  \setlength\Cdp{\dp0}
  \setlength\Cwd{\wd0}
  \setlength\Cvs{\baselineskip}
  \setlength\Chs{\wd0}
 \else %% 13Q
  \normalsize
  \setbox0\hbox{\char\euc"A1A1}% "
  \setlength\Cht{\ht0}
  \setlength\Cdp{\dp0}
  \setlength\Cwd{\wd0}
  \setlength\Cvs{\baselineskip}
  \setlength\Chs{\wd0}
 \fi
\fi

\newcommand{\small}{%
 \@setfontsize\small\@ixpt{19\@Q}%
 \abovedisplayskip .5\baselineskip
  \@plus .25\baselineskip \@minus .15\baselineskip
 \abovedisplayshortskip \z@ \@plus 1\p@
 \belowdisplayshortskip .3\baselineskip
  \@plus .15\baselineskip \@minus .1\baselineskip
 \def\@listi{\leftmargin\leftmargini
%             \topsep 4\p@ \@plus2\p@ \@minus2\p@
%             \parsep 2\p@ \@plus\p@ \@minus\p@
             \topsep .5\baselineskip
              \@plus .25\baselineskip \@minus .15\baselineskip
             \parsep \z@
             \itemsep \parsep}%
 \belowdisplayskip \abovedisplayskip}

\if@xiiQ
 \small
 \setbox0\hbox{\char\euc"A1A1}% "
 \setlength\Cht{\ht0}
 \setlength\Cdp{\dp0}
 \setlength\Cwd{\wd0}
 \setlength\Cvs{\baselineskip}
 \setlength\Chs{\wd0}
\fi

\newcommand{\footnotesize}{%
 \@setfontsize\footnotesize\@viiipt{14\@Q}%
 \abovedisplayskip .5\baselineskip
  \@plus .25\baselineskip \@minus .15\baselineskip
 \abovedisplayshortskip \z@ \@plus 1\p@
 \belowdisplayshortskip .3\baselineskip
  \@plus .15\baselineskip \@minus .1\baselineskip
 \def\@listi{\leftmargin\leftmargini
%             \topsep 3\p@ \@plus\p@ \@minus\p@
%             \parsep 2\p@ \@plus\p@ \@minus\p@
             \topsep .5\baselineskip
              \@plus .25\baselineskip \@minus .15\baselineskip
             \parsep \z@
             \itemsep \parsep}%
 \belowdisplayskip \abovedisplayskip}

\newcommand{\scriptsize}{\@setfontsize\scriptsize\@viipt{15\@Q}}
\newcommand{\tiny}{\@setfontsize\tiny\@vpt\@vipt}
\newcommand{\large}{\@setfontsize\large\@xiipt{27\@Q}}
\newcommand{\Large}{\@setfontsize\Large\@xivpt{21}}
\newcommand{\LARGE}{\@setfontsize\LARGE\@xviipt{25}}
\newcommand{\huge}{\@setfontsize\huge\@xxpt{34\@Q}}
\newcommand{\Huge}{\@setfontsize\Huge\@xxvpt{33}}

\headheight12H %% 11Q
\if@xiiQ
 \headsep5mm
\else
 \headsep5mm
\fi
\topskip1\Cht
\footskip\z@
\maxdepth .5\topskip

\if@MemWr
 \textwidth146.25mm %% (13Qx45W) [585H]
\else
  \textwidth150mm
  % (12Qx24W)x2 + (columnsep=24H) [576+24=600]
  % (13Qx22w)x2 + (columnsep=28H) [572+28=600]
  % (14Qx20w)x2 + (columnsep=40H) [560+40=600]
\fi
\@settopoint\textwidth
\if@xiiQ         %% 46x19+12=886
 \textheight 46\Cvs
 \advance \textheight \topskip
 \advance \textheight .2mm %% limit 0.15mm
\else
 \if@Foreword    %% 42x21+13=895
  \textheight 42\Cvs
  \advance \textheight \topskip
  \advance \textheight .1mm %% limit .013mm
 \else
  \if@xivQ       %% 41x21+14=875
   \textheight 41\Cvs
   \advance \textheight \topskip
   \advance \textheight .2mm %% limit .15mm
  \else
  %% 13Q         %% 43x20+13=873
   \textheight 43\Cvs
   \advance \textheight \topskip
   \advance \textheight .3mm %% limit .25mm
  \fi
 \fi
\fi
\@settopoint\textheight

\if@twocolumn
  \setlength\marginparsep{10\p@}
\else
  \setlength\marginparsep{10\p@}
\fi
\setlength\marginparpush{5\p@}

\iftombow
% \hoffset\z@
% \voffset\z@
 \topmargin\paperheight
 \advance \topmargin -\textheight
 \advance \topmargin -\headheight
 \advance \topmargin -\headsep
 \advance \topmargin -\footskip
 \divide \topmargin \tw@
 \if@xiiQ %% 12Q
  \advance \topmargin -4.2mm
 \else    %% 13Q
  \advance \topmargin -4.3mm
 \fi
 \advance \topmargin -1in
 \@settopoint\topmargin
 \oddsidemargin\paperwidth
 \advance \oddsidemargin -\textwidth
 \divide \oddsidemargin \tw@
 \advance \oddsidemargin -1in
 \@settopoint\oddsidemargin
 \evensidemargin\oddsidemargin
 \@settopoint\evensidemargin
\else
 \topmargin \z@
 \@settopoint\topmargin
 \oddsidemargin\z@
 \@settopoint\oddsidemargin
 \evensidemargin\z@
 \@settopoint\evensidemargin
\fi

\marginparwidth 2in
\@settopoint\marginparwidth

\footnotesep 2.45mm % 14H x 0.7
\skip\footins .75\Cvs \@plus .25\Cvs \@minus .5\Cvs
\floatsep 1\Cvs \@plus 2\p@ \@minus 2\p@
\textfloatsep 1.5\Cvs \@plus 2\p@ \@minus 4\p@
\intextsep 1.5\Cvs \@plus 2\p@ \@minus 2\p@
\dblfloatsep 1\Cvs \@plus 2\p@ \@minus 2\p@
\dbltextfloatsep 1.5\Cvs \@plus 2\p@ \@minus 4\p@

\@fptop 0\p@ \@plus 1fil
\@fpsep 8\p@ \@plus 2fil
\@fpbot 0\p@ \@plus 1fil
\@dblfptop 0\p@ \@plus 1fil
\@dblfpsep 8\p@ \@plus 2fil
\@dblfpbot 0\p@ \@plus 1fil
\partopsep \z@

\def\@listi{\leftmargin\leftmargini
  \topsep.5\Cvs \@plus .25\Cvs \@minus .15\Cvs
  \parsep\z@
  \itemsep\parsep
}
\let\@listI\@listi
\@listi
\def\@listii{\leftmargin\leftmarginii
   \labelwidth\leftmarginii \advance\labelwidth-\labelsep
   \topsep 4\p@ \@plus2\p@ \@minus\p@
   \parsep 2\p@ \@plus\p@  \@minus\p@
   \itemsep\parsep}
\def\@listiii{\leftmargin\leftmarginiii
   \labelwidth\leftmarginiii \advance\labelwidth-\labelsep
   \topsep    2\p@  \@plus\p@\@minus\p@
   \parsep    \z@
   \partopsep \p@ \@plus\z@ \@minus\p@
   \itemsep\topsep}
\def\@listiv {\leftmargin\leftmarginiv
              \labelwidth\leftmarginiv
              \advance\labelwidth-\labelsep}
\def\@listv  {\leftmargin\leftmarginv
              \labelwidth\leftmarginv
              \advance\labelwidth-\labelsep}
\def\@listvi {\leftmargin\leftmarginvi
              \labelwidth\leftmarginvi
              \advance\labelwidth-\labelsep}

\if@xiiQ
 \columnsep6mm    %% 12Qx2
\else
 \if@xivQ
  \columnsep40\@Q
 \else
  \columnsep28\@Q %% 13Qx2+2
 \fi
\fi
\columnseprule 0\p@
\lineskip 1\p@
\normallineskip 1\p@
\renewcommand{\baselinestretch}{}
\parskip\z@
\parindent1zw

\@lowpenalty   51
\@medpenalty  151
\@highpenalty 301
\setcounter{topnumber}{6}
\setcounter{bottomnumber}{6}
\setcounter{totalnumber}{12}
\setcounter{dbltopnumber}{6}
\renewcommand{\topfraction}{.95}
\renewcommand{\bottomfraction}{.95}
\renewcommand{\textfraction}{.05}
\renewcommand{\floatpagefraction}{.05}
\renewcommand{\dbltopfraction}{.95}
\renewcommand{\dblfloatpagefraction}{.05}

\if@Proof
 \def\@Rtop{\rlap{\smash{\rule[-\headsep]{0.05mm}{10mm}%
  \rule[-\headsep]{10mm}{0.05mm}}}}
 \def\@Ltop{\llap{\smash{\rule[-\headsep]{10mm}{0.05mm}%
  \rule[-\headsep]{0.05mm}{10mm}}}}
 \def\@Rbot{\rlap{\smash{\raisebox{1\footskip}
  {\rule[-10mm]{0.05mm}{10mm}\rule{10mm}{0.05mm}}}}}
 \def\@Lbot{\llap{\smash{\raisebox{1\footskip}
  {\rule{10mm}{0.05mm}\rule[-10mm]{0.05mm}{10mm}}}}}
\else
 \let\@Rtop\relax\let\@Ltop\relax\let\@Rbot\relax\let\@Lbot\relax
\fi

\def\ps@empty{\let\ps@jpl@in\ps@plain%
  \def\@oddhead{\@Ltop\hfil\@Rtop}%
  \def\@oddfoot{\@Lbot\hfil\@Rbot}%
  \let\@evenhead\@oddhead
  \let\@evenfoot\@oddfoot
  \let\@mkboth\@gobbletwo
  \let\chaptermark\@gobble
  \let\sectionmark\@gobble
}
\def\ps@plain{\let\@mkboth\@gobbletwo
 \let\ps@jpl@in\ps@plain
 \def\@oddhead{\@Ltop\hfil{\nombre@font \thepage}\hskip3mm\@Rtop}%
 \def\@evenhead{\@Ltop\hskip3mm{\nombre@font \thepage}\hfil\@Rtop}%
 \def\@oddfoot{\@Lbot\hfil\@Rbot}%
 \let\@evenfoot\@oddfoot}
\let\ps@jpl@in\ps@plain

\def\Vol#1{% Vol.59 = Year 2003
 \def\@tempa{#1}%
 \ifx\@tempa\empty
  \gdef\@Vol{xx}\gdef\@Year{xxxx}%
 \else
  \edef\@tempb{\zap@space#1 \@empty}%
  \afterassignment\remove@to@nnil
   \count@ 0\@tempb\relax\@nnil
  \ifnum\count@=\z@
   \gdef\@Vol{xx}%
  \else
   \@tempcnta=#1\relax
   \advance \@tempcnta 1944\relax
   \xdef\@Year{\the\@tempcnta}%
   \gdef\@Vol{\zap@space#1 \@empty}%
  \fi
 \fi
}
\def\@Vol{xx}%
\def\@Year{xxxx}

\def\No#1{%
 \def\@tempa{#1}%
 \ifx\@tempa\empty
  \gdef\@No{xx}%
 \else
   \gdef\@No{#1}%
 \fi
}
\def\@No{xx}

\def\JASJpage@range{%
 \@ifundefined{r@jasj@lastpage}{\def\last@page{1}\def\get@lp{1}}%
  {\edef\exp@lp{\csname r@jasj@lastpage\endcsname}%
   \edef\get@lp{\expandafter\@cdr\exp@lp\@nil}%
   \def\last@page{%
    \@tempcnta\get@lp\relax
    \the\@tempcnta
   }%
  }%
  \ifnum\get@lp=\c@page
   p.\,\thepage
  \else
   pp.\,\thepage--\last@page
  \fi
}

\def\nombre@font{\slshape\normalsize}% \fontsize{10.95}{\z@}\selectfont
\def\head@font{\footnotesize}

\def\ps@FPjasj{\let\@mkboth\@gobbletwo
 \let\ps@jpl@in\ps@headnombre
 \def\@oddhead{\@Ltop
   \hskip3mm
   {\head@font
    日本音響学会誌 \@Vol 巻\@No 号（\@Year{}），\JASJpage@range}\hfil
   {\nombre@font \thepage}\hskip3mm
   \@Rtop}%
 \def\@evenhead{\@Ltop
   \hskip3mm{\nombre@font \thepage}\hfil
   {\head@font
    日本音響学会誌 \@Vol 巻 \@No 号（\@Year{}），\JASJpage@range\unskip}%
   \hskip3mm
   \@Rtop}%
 \def\@oddfoot{\@Lbot\hfil\@Rbot}%
 \let\@evenfoot\@oddfoot
}

\def\ps@jasj{\let\@mkboth\@gobbletwo
 \let\ps@jpl@in\ps@headnombre
 \def\@oddhead{\@Ltop\hbox to \textwidth{\hskip3mm %%?? 3mm
  {\head@font \head@title}\hss{\nombre@font \thepage}\hskip3mm}\@Rtop}%
 \def\@evenhead{\@Ltop
   \hskip3mm{\nombre@font \thepage}\hfil
   {\head@font
    日本音響学会誌 \@Vol 巻\@No 号（\@Year{}）\inhibitglue}\hskip3mm
   \@Rtop}%
 \def\@oddfoot{\@Lbot\hfil\@Rbot}%
 \let\@evenfoot\@oddfoot
}

\def\measure@head#1{%
 \setbox\@tempboxa\hbox{\def\\{\unskip\ignorespaces}%
  \head@font #1}%
 \ifdim \wd\@tempboxa > 136mm
  \jasj@warning{header is too long. make it shorter.
  ^^J\@spaces For example, \string\title[header title]{title}}%
    \fi
}

\if@MemWr
\def\ps@MemWr@plain{\let\@mkboth\@gobbletwo
 \let\ps@jpl@in\ps@plain
 \def\@oddhead{\@Ltop\hfil{\nombre@font \thepage}\hskip1.125mm\@Rtop}%
 \def\@evenhead{\@Ltop\hskip1.125mm{\nombre@font \thepage}\hfil\@Rtop}%
 \def\@oddfoot{\@Lbot\hfil\@Rbot}%
 \let\@evenfoot\@oddfoot}
\let\ps@jpl@in\ps@plain

\def\ps@MemWr@jasj{\let\@mkboth\@gobbletwo
 \let\ps@jpl@in\ps@headnombre
 \def\@oddhead{\@Ltop\hbox to \textwidth{\hskip1.125mm
  {\head@font 追悼文}\hss{\nombre@font \thepage}\hskip1.125mm}\@Rtop}%
 \def\@evenhead{\@Ltop
   \hskip1.125mm{\nombre@font \thepage}\hfil
   {\head@font
    日本音響学会誌 \@Vol 巻\@No 号（\@Year{}）\inhibitglue}\hskip1.125mm
   \@Rtop}%
 \def\@oddfoot{\@Lbot\hfil\@Rbot}%
 \let\@evenfoot\@oddfoot
}
\fi

\def\title{\@ifnextchar[% ]
 {\d@title}{\s@title}}
\def\d@title[#1]#2{%
 \gdef\head@title{#1}\measure@head{#1}%
 \gdef\@title{\inhibitglue #2\inhibitglue}}
\def\s@title#1{%
 \gdef\head@title{\def\\{\unskip\ignorespaces}%
  #1}\measure@head{#1}\gdef\@title{\inhibitglue #1\inhibitglue}}
\def\@title{}
\def\head@title{}

\newif\if@use@subtitle \@use@subtitlefalse
\def\subtitle#1{\@use@subtitletrue
 \gdef\@subtitle{#1}}
\def\@subtitle{}

\def\SubjectClassificationNo#1{\gdef\@SCNo{#1}}
\def\@SCNo{}

\long\def\etitle#1{\gdef\@etitle{#1\unskip\if@xiiQ,\else.\fi}}
\def\@etitle{}
\def\foot@etitle{%
 \ifx\@etitle\empty\else
  \footnotetext[0]{\@etitle}%
 \fi
}

\def\@etitlemark{%
 \hbox{\@textsuperscript{\normalfont *}}%
}

%% 会議報告/解説/やさしい解説/特別講演/研究発表会報告
\def\TypeofReviews#1{\gdef\@TypeofReviews{#1}}
\def\@TypeofReviews{}

\def\FeatureTitle#1{\gdef\@FeatureTitle{#1}}
\def\@FeatureTitle{}

\if@xiiQ
 \def\output@TypeofDoc{{\normalsize\bfseries
  \kintou{5zw}{\@Type@fDoc}}}%
\else
 \def\output@TypeofDoc{{\bfseries\fontsize{16\@Q}{\z@}\selectfont
  \hskip1zw
  \@Type@fDoc\zdash \ignorespaces\@FeatureTitle\unskip\zdash}}
\fi

\if@xiiQ
 \def\title@font{\bfseries\large}
 \def\subtitle@font{\bfseries\fontsize{10.95}{22\@Q}\selectfont}
 \def\author@font{\fontsize{10.95}{22\@Q}\selectfont}
\else
 \def\title@font{\bfseries\huge}
 \def\subtitle@font{\bfseries\fontsize{16\@JQ}{20\@Q}\selectfont}
 \def\author@font{\bfseries\fontsize{10.95}{22\@Q}\selectfont}
\fi

\newtoks\@authorlist
\newcount\@authorcnt
\newcount\@alcnt
\newcount\p@alcnt
 \p@alcnt20\relax
\newcount\@totalnumber

\def\authorlist#1{%
 \@authorlist={#1}\the\@authorlist
}

\def\get@al#1{% 12Q
 \def\al@none{none}\def\@tempaffi{#1}%
 \ifx\al@none\@tempaffi\else
  \@for\get@label:=#1\do{%
   \@ifundefined{al@\get@label}%
    {%
     \global\advance \@alcnt \@ne
     \expandafter\xdef\csname al@\get@label\endcsname{\the\@alcnt}%
     \global\advance \@tempcnta \@ne
     \protected@xdef\plural@affi{\plural@affi
      \ifnum\@tempcnta=\@ne
       $^{\@fnsymbol{\csname al@\get@label\endcsname}}$%
      \else
       $^{,\@fnsymbol{\csname al@\get@label\endcsname}}$%
      \fi
     }%
    }%
    {%
     \global\advance \@tempcnta \@ne
     \protected@xdef\plural@affi{\plural@affi
      \ifnum\@tempcnta=\@ne
       $^{\@fnsymbol{\csname al@\get@label\endcsname}}$%
      \else
       $^{,\@fnsymbol{\csname al@\get@label\endcsname}}$%
      \fi
     }%
    }%
  }%
 \fi
}
\def\plural@affi{}

\def\name@expandafter#1#2{%
 \def\next{#1}%
 \edef\@tempa{#2}%
 \ifx\@tempa\@empty
  \jasjline@warning{author's name is empty!}%
  \def\@tempa{\@empty}%
 \fi
 \expandafter\next\@tempa}
\def\chk@name#1{%
 \name@expandafter\@chk@name{#1}\@nil}
\def\@chk@name#1#2\@nil{\def\get@oneword{#1}}

\def\fmt@Jan#1{% 12Q and 13Q
 \@temptokena{#1}%
 \def\hold@name{\the\@temptokena\unskip}%
 \chk@name{\the\@temptokena}%
 \setbox\@tempboxa\hbox{\get@oneword}%
  \ifdim \wd\@tempboxa<1zw
   %% English name
   \let\@authorname\hold@name
  \else
   \setbox\@tempboxa\hbox{\spaceskip100mm \hold@name}%
   \ifdim \wd\@tempboxa < 100mm
    \jasj@warning{Author's name "#1" doesn't have a space}%
    \let\@authorname\hold@name
   \else
    \setbox\@tempboxa\hbox{\hold@name}%
    \ifdim \wd\@tempboxa < 5zw
     \ifdim \wd\@tempboxa < 4zw
      \ifdim \wd\@tempboxa < 3zw
       %% 2字 (□ □)
       \def\@authorname{\hbox to 5zw{%
        \spaceskip\z@ plus 1fil
        \hold@name}}%
      \else
       %% 3字 (□ □□)
       \def\@authorname{\hbox to 5zw{%
        \spaceskip1.5zw\kanjiskip\z@ plus 1fil
        \hold@name}}%
      \fi
     \else
      %% 4字 (□□ □□ or □ □□□)
      \def\chk@first@second##1 ##2\@nil{%
       \global\setbox\@tempboxa\hbox{\ignorespaces ##1\unskip}%
       \global\setbox\@tempboxb\hbox{\ignorespaces ##2\unskip}}%
      \edef\@tempcheck{\expandafter\chk@first@second #1\@nil}\@tempcheck
      \@tempswafalse
      \ifdim\wd\@tempboxa>2.5zw
       \@tempswatrue
      \else
       \ifdim\wd\@tempboxb>2.5zw
        \@tempswatrue
       \fi
      \fi
      \if@tempswa
       %% 4字 (□ □□□)
       \def\@authorname{\hbox to 5zw{%
        \spaceskip.5zw plus 1fil\kanjiskip.25zw plus 1fil
         \hold@name}}%
      \else
       %% 4字 (□□ □□)
       \def\@authorname{\hbox to 5zw{%
        \spaceskip\z@ plus 1fil\kanjiskip\z@ plus 1fil
         \hold@name}}%
      \fi
     \fi
    \else
     %% >= 5字 (□□□ □□)
     \def\@authornamesep{}%
     \expandafter\ifcat\get@oneword ア%
      \def\@authornamesep{\hskip.5zw}%
     \fi
     \def\tmp@name##1 ##2\@nil{##1\@authornamesep ##2}%
     \edef\@authorname{\expandafter\tmp@name\the\@temptokena\@nil\unskip}%
    \fi
   \fi
  \fi
}

\def\authorentry#1#2#3{\@ifnextchar[% ]
 {\@aeP{#1}{#2}{#3}}{\@ae{#1}{#2}{#3}}}

\if@xiiQ
 \def\@ae#1#2#3{% 12Q
  \@tempcnta\z@
  \advance \@authorcnt \@ne
  %% author label
  \get@al{#3}%
  %% author's name in Japanese
  \fmt@Jan{#1}%
  \expandafter\xdef\csname @Jauthorname\number\@authorcnt\endcsname{%
   \@authorname\kern\z@\plural@affi}%
  %% author's name in English
  \@temptokena{#2}%
  \expandafter\xdef\csname @Eauthorname\number\@authorcnt\endcsname{%
   \the\@temptokena}%
  \global\@totalnumber\@authorcnt
  \def\plural@affi{}%
 }

 \def\@aeP#1#2#3[#4]{% 12Q
  \@tempcnta\z@
  \advance \@authorcnt \@ne
  %% author label
  \get@al{#3}%
  \@ifundefined{p@al@#4}%
   {\global\advance \p@alcnt \@ne
    \expandafter\xdef\csname p@al@#4\endcsname{\the\p@alcnt}}%
   {\relax}%
  %% author's name in Japanese
  \fmt@Jan{#1}%
  \expandafter\xdef\csname @Jauthorname\number\@authorcnt\endcsname{%
   \@authorname\kern\z@\plural@affi
   $^{,\@fnsymbol{\csname p@al@#4\endcsname}}$}%
  %% author's name in English
  \@temptokena{#2}%
  \expandafter\xdef\csname @Eauthorname\number\@authorcnt\endcsname{%
   \the\@temptokena}%
  \global\@totalnumber\@authorcnt
  \def\plural@affi{}%
 }
\else % 13Q

 \def\fmt@al#1{% 13Q
  \@ifundefined{al@#1}%
   {\global\advance \@alcnt \@ne
    \expandafter\xdef\csname al@#1\endcsname{\the\@alcnt}%
   }{}%
 }

 \newcount\total@alcnt

 \def\@ae#1#2#3{% 13Q
  \advance \@authorcnt \@ne
  %% author label
  \fmt@al{#3}%
  %% author's name in Japanese
  \fmt@Jan{#1}%
  \expandafter\xdef\csname @Jauthorname\number\@authorcnt\endcsname{%
   {\@authorname}{\csname al@#3\endcsname}}%
  %% author's name in English
  \@temptokena{#2}%
  \expandafter\xdef\csname @Eauthorname\number\@authorcnt\endcsname{%
   {\the\@temptokena}{\csname al@#3\endcsname}}%
  \global\@totalnumber\@authorcnt
  \global\total@alcnt\@alcnt
 }
 %% \def\@aeP#1#2#3[#4]{} --> no need
\fi

\def\output@Jauthorlist{% 12Q
 \ifx\assigned@bal\empty
  \align@author
  \expandafter\@breakauthorline\expandafter{\align@number}%
 \else
  \@breakauthorline{\assigned@bal}%
 \fi
 \@authorcnt\z@
 \loop\ifnum \@authorcnt < \@totalnumber
  \advance \@authorcnt \@ne
  \leavevmode
  \csname @Jauthorname\number\@authorcnt\endcsname
   \csname @bal\number\@authorcnt\endcsname
 \repeat
}

\def\align@author{% 12Q
 \if@ShortNote
  \def\align@number{3,6,9,12}%
 \else
  \ifnum\@totalnumber<5\relax
   \def\align@number{4}%
  \else
   \ifnum\@totalnumber<11\relax
    \@tempcnta\@totalnumber
    \ifodd\@tempcnta \advance \@tempcnta \@ne\fi
    \divide \@tempcnta \tw@
    \edef\align@number{\the\@tempcnta}%
   \else
    \def\align@number{5,10,15,20}%
   \fi
  \fi
 \fi
}

\def\breakauthorline#1{\gdef\assigned@bal{#1}}
\def\assigned@bal{}

\def\@breakauthorline#1{% 12Q
 \@for\@breakauthor:=#1\do{%
  \expandafter\gdef\csname @bal\@breakauthor\endcsname{\\}%
 }%
  \@authorcnt\z@
  \loop
   \ifnum \@authorcnt<\@totalnumber
    \advance \@authorcnt \@ne
    \@ifundefined{@bal\number\@authorcnt}%
     {%
      \if@ShortNote
       \expandafter\gdef\csname @bal\number\@authorcnt\endcsname{\hskip.75zw}%
      \else
       \expandafter\gdef\csname @bal\number\@authorcnt\endcsname{\hskip1zw}%
      \fi
     }{}%
  \repeat
}

\def\@outputEauthorlist{% 12Q
 \@authorcnt\z@
 \@tempcnta\@totalnumber \advance \@tempcnta -\@ne
  \loop
   \ifnum \@authorcnt < \@totalnumber
    \advance \@authorcnt \@ne
    \ifnum \@authorcnt < \@tempcnta
     \ignorespaces
     \csname @Eauthorname\number\@authorcnt\endcsname\unskip,
    \else
     \ifnum \@authorcnt=\@totalnumber
      \ignorespaces
      \csname @Eauthorname\number\@authorcnt\endcsname\unskip.\ignorespaces
     \else
      \ignorespaces
      \csname @Eauthorname\number\@authorcnt\endcsname\unskip\
%%     \ifnum \@totalnumber=\tw@\ \else , \fi
      and\ \ignorespaces
     \fi
    \fi
  \repeat
}

\def\foot@outputEauthorlist{% 12Q
 \footnotetext[25]{%
  by\
  \@outputEauthorlist
 }%
}

\def\breakauthorlabel#1{% 13Q
 \@for\@breakauthor:=#1\do{%
  \expandafter\gdef\csname @balb\@breakauthor\endcsname{\cr}%
 }%
}

\def\process@Aauthorlist{\global\@alcnt\z@ \@process@Aauthorlist}

\def\@process@Aauthorlist{% 13Q
 \global\advance \@alcnt \@ne
 %%
 \leavevmode
 \@tempcnta\z@
 \ifnum\@alcnt>\@ne\unskip\kern-.15zw ・\allowbreak
  \@tempcnta\@alcnt
  \advance \@tempcnta -\@ne
 \fi
 \expandafter\let\csname @balb0\endcsname\relax
 \csname @balb\number\@tempcnta\endcsname
 %%
 \csname @JauthornameL\number\@alcnt\endcsname
 \ifx\al@none\@undefined
  \def\al@none{0}%
 \fi
 \ifnum\al@none=\@alcnt
  \footnotemark[\the\@alcnt]%
 \else
  {\footnotesize\bfseries
   （\csname @Jafii\number\@alcnt\endcsname{}）\inhibitglue}%
    \footnotemark[\the\@alcnt]%
 \fi
 %%
 \ifnum \@alcnt < \total@alcnt \expandafter\@process@Aauthorlist\fi
}

\def\output@Aauthorlist{% 13Q
 \fmt@Aauthorlist
 \setbox\@tempboxa\vbox{\halign{\hfill ##\cr
   \process@Aauthorlist\cr
  }%
 }%
 %%
 \@tempdima\wd\@tempboxa
 \ifdim \@tempdima > \textwidth
  \leavevmode
  \hbox to \textwidth{\leaders\hrule height.12mm\hfil}\par
  \nointerlineskip
  \vskip1.5mm
  \setbox\@tempboxa\hbox{\refmt@Aauthorlist}%
  \raggedleft
  \unhbox\@tempboxa
 \else
  \leavevmode\hfill
  \hbox to \@tempdima{\leaders\hrule height.12mm\hfil}\par
  \nointerlineskip
  \vskip1.5mm
  \leavevmode\hfill
  \box\@tempboxa
 \fi
}

\def\fmt@Aauthorlist{% 13Q
 \@alcnt\z@
 \loop\ifnum \@alcnt < \total@alcnt
  \advance \@alcnt \@ne
  \expandafter\let\csname @JauthornameL\number\@alcnt\endcsname\@empty
  {\combine@Jan}%
 \repeat
}

\def\refmt@Aauthorlist{% 13Q
 \@alcnt\z@
 \loop\ifnum \@alcnt < \total@alcnt
  \advance \@alcnt \@ne
  \expandafter\let\csname @JauthornameL\number\@alcnt\endcsname\@empty
  {\combine@Jan}%
  %%
  \leavevmode
  \ifnum\@alcnt>\@ne\unskip\kern-.15zw ・\allowbreak\fi
  \mbox{\csname @JauthornameL\number\@alcnt\endcsname
   \ifnum\al@none=\@alcnt
    \footnotemark[\the\@alcnt]%
   \else
    {\footnotesize\bfseries
     （\csname @Jafii\number\@alcnt\endcsname{}）\inhibitglue}%
      \footnotemark[\the\@alcnt]%
   \fi
  }\kern0pt\ignorespaces
 \repeat
}

\def\combine@Jan{% 13Q
 \@authorcnt\z@
 \@tempswafalse
 \loop\ifnum \@authorcnt < \@totalnumber
  \advance \@authorcnt \@ne
  \edef\an@al{\csname @Jauthorname\number\@authorcnt\endcsname}%
  \ifnum\@alcnt=\expandafter\@secondoftwo\an@al
   \expandafter\protected@xdef\csname @JauthornameL\number\@alcnt\endcsname{%
    \csname @JauthornameL\number\@alcnt\endcsname
    \if@tempswa ，%
    \fi
    \ignorespaces\expandafter\@firstoftwo\an@al\unskip
   }%
   \@tempswatrue
  \fi
 \repeat
}

\def\foot@outputAauthorlist{% 13Q
 \fmt@Eauthorlist
}

\def\fmt@Eauthorlist{% 13Q
 \@alcnt\z@
 \loop\ifnum \@alcnt < \total@alcnt
  \advance \@alcnt \@ne
  \let\@Eauthorname\@empty
  {\combine@Ean}%
  %%
  \footnotetext[\the\@alcnt]{%
   \@Eauthorname\unskip\
   \csname @Eafii\number\@alcnt\endcsname}%
 \repeat
}

\newcount\@sameaffinum

\def\combine@Ean{% 13Q
 \@sameaffinum\z@
 \@authorcnt\z@
 \loop\ifnum \@authorcnt < \@totalnumber
  \advance \@authorcnt \@ne
  \edef\an@al{\csname @Eauthorname\number\@authorcnt\endcsname}%
  \ifnum\@alcnt=\expandafter\@secondoftwo\an@al
   \advance \@sameaffinum \@ne
  \fi
 \repeat
 %%
 \@authorcnt\@totalnumber
 \advance \@authorcnt \@ne
 \@tempcnta\@ne
 \@tempcntb\z@
 \loop\ifnum \@authorcnt > \@tempcnta
  \advance \@authorcnt -\@ne
  \edef\an@al{\csname @Eauthorname\number\@authorcnt\endcsname}%
  \ifnum\@alcnt=\expandafter\@secondoftwo\an@al
   \advance \@tempcntb \@ne
   \protected@xdef\@Eauthorname{%
    \ifnum\@sameaffinum=\@ne
     \ignorespaces\expandafter\@firstoftwo\an@al\unskip
    \else
     \ifnum\@tempcntb=\@ne
      \unskip\ and\
      \ignorespaces\expandafter\@firstoftwo\an@al\unskip
     \else
      \ifnum\@tempcntb=\tw@
       \ignorespaces\expandafter\@firstoftwo\an@al\unskip % ,
      \else
       \ignorespaces\expandafter\@firstoftwo\an@al\unskip,
      \fi
     \fi
     \@Eauthorname
    \fi
   }%
  \fi
 \repeat
}
\def\@Eauthorname{}

\newcount\chk@alcnt
\newcount\chk@p@alcnt
\if@xiiQ
 \def\affiliate[#1]#2{% 12Q
  \advance \chk@alcnt \@ne
  \@ifundefined{al@#1}%
   {\expandafter\def\csname al@#1\endcsname{1}%
    \jasj@warning{Check the "#1" label, it does not correspond to
      ^^J\@spaces any labels in \string\authorentry\space command}%
   }{}%
  \protected@xdef\@jaffiliate{\@jaffiliate
    \protect\footnotetext[\csname al@#1\endcsname]{#2}}%
 }
 \def\@jaffiliate{}

 \def\paffiliate[#1]#2{% 12Q
  \advance \chk@p@alcnt \@ne
  \@ifundefined{p@al@#1}%
   {\expandafter\def\csname p@al@#1\endcsname{1}%
    \jasj@warning{Check the "#1" label, it does not correspond to
      ^^J\@spaces any labels in \string\authorentry\space command}%
   }{}%
  \protected@xdef\p@jaffiliate{\p@jaffiliate
    \protect\footnotetext[\csname p@al@#1\endcsname]{#2}}%
 }
 \def\p@jaffiliate{}
\else
 \def\affiliate[#1]#2#3{% 13Q
  \advance \chk@alcnt \@ne
  \@ifundefined{al@#1}%
   {\expandafter\def\csname al@#1\endcsname{1}% <<-- ??? why 1
    \jasj@warning{Check the "#1" label, it does not correspond to
      ^^J\@spaces any labels in \string\authorentry\space command}%
   }{}%
  \@temptokena{#2}%
  \expandafter\xdef\csname @Jafii\number\chk@alcnt\endcsname{%
   \the\@temptokena}%
  \@temptokena{#3}%
  \expandafter\xdef\csname @Eafii\number\chk@alcnt\endcsname{%
   \the\@temptokena}%
 }
 % \def\paffiliate[#1]#2#3{}
\fi

\def\CorrespondingTo#1#2{\gdef\@CorrespondingTo{#1\unskip\hskip1zw #2}}
\def\@CorrespondingTo{？？}
\def\foot@CorrTo{%
 \footnotetext[25]{%
  \inhibitglue （問合先\hbox to 1zw{\hss ：\hss}%
   \@CorrespondingTo{}）\inhibitglue}%
}

\def\received#1#2#3{%
 \gdef\@received{#1年#2月#3日}%
}
\def\@received{？？}
\def\accepted#1#2#3{%
 \gdef\@accepted{#1年#2月#3日}%
}
\def\@accepted{？？}
\def\foot@acceptance{%
 \footnotetext[25]{\xkanjiskip .15zw plus 1.0pt minus 1.0pt
  \inhibitglue （\@received 受付，
  \@accepted 採録決定）\inhibitglue}%
}

\newbox\abstract@box
\def\abstract{%
 \global\setbox\abstract@box\hbox\bgroup
  \if@xiiQ\footnotesize\fi
  \ignorespaces
}
\def\endabstract{%
  \inhibitglue\ignorespaces
 \egroup
 \if@xiiQ\else
  \if@TechPlaza\else %% 技術プラザ
   \output@abstractbox\par
  \fi
 \fi
}

\newbox\keywords@box
\def\keywords{%
 \global\setbox\keywords@box\hbox\bgroup
  \if@xiiQ\footnotesize\fi
  \ignorespaces
}
\def\endkeywords{%
  \inhibitglue\ignorespaces
 \egroup
}

%% for Paper
\if@xiiQ %% 論文 技術報告
 \def\output@abstractbox{%
  \begin{minipage}{132mm}% 11Qx48w
   \footnotesize\baselineskip17\@Q
   \parindent1zw
   {\bfseries \<［要旨］\<}\hskip1zw\unhbox\abstract@box\par
   \vskip3\@Q
   \leftskip7zw
   \hskip-7zw{\bfseries キーワード}\hskip1zw\unhbox\keywords@box
  \end{minipage}%
 }
\else %% 小特集など
 \def\output@abstractbox{%
  \parindent1zw
  {\bfseries \<［要旨］\<}\hskip1zw\unhbox\abstract@box\par
  \ifvoid\keywords@box\else
   \@hang{{\bfseries \hskip1zw キーワード}\hskip1zw}\unhbox\keywords@box\par
  \fi
 }
\fi

%% 研究速報
 \def\output@Letterkeywordsbox{%
  \begin{minipage}{132mm}% 11Qx48w
   \footnotesize\baselineskip17\@Q
   \parindent1zw
   \leftskip7zw
   \hskip-7zw{\bfseries キーワード}\hskip1zw\unhbox\keywords@box
  \end{minipage}%
 }

%% for 寄書
\def\output@SNkeywordsbox{%
 \begin{minipage}{68.75mm}% 11Qx25w
  \footnotesize\baselineskip17\@Q
  \leftskip6zw
  \hskip-6zw{\bfseries キーワード}\hskip1zw\unhbox\keywords@box
 \end{minipage}%
}

\newdimen\BelowTitleSep \BelowTitleSep\z@

%\def\thefootnote{\fnsymbol{footnote}}
\if@xiiQ
 \def\@fnsymbol#1{%\ensuremath{%
  \ifcase#1{*}\or {*}1\or {*}2\or {*}3\or
   {*}4\or {*}5\or {*}6\or {*}7\or {*}8\or {*}9\or
   {*}10\or {*}11\or {*}12\or {*}13\or {*}14\or {*}15\or
   {*}16\or {*}17\or {*}18\or {*}19\or {*}20\or
   \dagger\or \dagger\dagger\or \dagger\dagger\dagger\or
   \dagger\dagger\dagger\dagger \or %25
  \else\@ctrerr\fi %}
 }
\else
 \def\@fnsymbol#1{%\ensuremath{%
  \ifcase#1{*}\or {*}{*}\or {*}{*}{*}\or {*}{*}{*}{*}\or
   {*}4\or {*}5\or {*}6\or {*}7\or {*}8\or {*}9\or
   {*}10\or {*}11\or {*}12\or {*}13\or {*}14\or {*}15\or
   {*}16\or {*}17\or {*}18\or {*}19\or {*}20\or
   \dagger\or \dagger\dagger\or \dagger\dagger\dagger\or
   \dagger\dagger\dagger\dagger \or %25
  \else\@ctrerr\fi %}
 }
\fi

\newcommand{\maketitle}{\par
 \ifnum \chk@alcnt < \@alcnt
  \jasj@warning{information of \string\affiliate\space is not specified}%
 \fi
 \advance \p@alcnt -20\relax
 \ifnum \chk@p@alcnt < \p@alcnt
  \jasj@warning{information of \string\paffiliate\space is not specified}%
 \fi
 \begingroup
  %%
  \renewcommand{\thefootnote}{\fnsymbol{footnote}}%
  \def\@makefnmark{\hbox{$\m@th^{\@thefnmark}$}}%
  \if@xiiQ
   \long\def\@makefntext##1{%
    \clubpenalty\@M
    \widowpenalty\@M
    \parindent\z@
    \leftskip1.5zw
    \leavevmode
    \hbox to \z@{\hss $^{\@thefnmark}$\hskip.25zw}##1%
   }%
  \else % 13Q
   \ifnum\total@alcnt>3\relax
   \def\@fnsymbol##1{%\ensuremath{%
    \ifcase##1{*}\or {*}1\or {*}2\or {*}3\or
     {*}4\or {*}5\or {*}6\or {*}7\or {*}8\or {*}9\or
     {*}10\or {*}11\or {*}12\or {*}13\or {*}14\or {*}15\or
     {*}16\or {*}17\or {*}18\or {*}19\or {*}20\or
     \dagger\or \dagger\dagger\or \dagger\dagger\dagger\or
     \dagger\dagger\dagger\dagger \or %25
    \else\@ctrerr\fi %}
   }%
   \fi
   \long\def\@makefntext##1{%
    \clubpenalty\@M
    \widowpenalty\@M
    \parindent\z@
    \ifnum\total@alcnt>3\relax
     \@tempdima=1.5zw
    \else
     \ifnum\total@alcnt<\thr@@
      \@tempdima=1.5zw
     \else
      \@tempdima=2.5zw
     \fi
    \fi
    \leftskip\@tempdima
    \leavevmode
    \hbox to \z@{\hss $^{\@thefnmark}$\hskip.25zw}##1%
   }%
  \fi
  %%
  \ifnum\col@number=\@ne \@maketitle
  \else
   \if@ShortNote
    \@makeSNtitle
   \else
    \twocolumn[\@maketitle]%
   \fi
  \fi
  \thispagestyle{FPjasj}%
  \if@jasjconf
  \else
   \foot@etitle
   \if@xiiQ
    \foot@outputEauthorlist
    \@jaffiliate
    \p@jaffiliate
    \foot@CorrTo
    \foot@acceptance
   \else
    \foot@outputAauthorlist
   \fi
  \fi
 \endgroup
 \setcounter{footnote}{0}%
 \global\let\maketitle\relax
 \global\let\@makePtitle\relax
 \global\let\@makeFtitle\relax
 \global\let\@makeFWtitle\relax
 \global\let\@makeMISCtitle\relax
 \global\let\title\relax
 \global\let\d@title\@empty
 \global\let\s@title\@empty
 \global\let\subtitle\relax
 \global\let\@subtitle\@empty
 \global\let\etitle\relax
 \global\let\@etitle\relax
}

\def\jasj@shortstack{\@ifnextchar[\@jasj@shortstack{\@jasj@shortstack[c]}}
\def\@jasj@shortstack[#1]{%
  \leavevmode
  \vbox\bgroup
%    \baselineskip-\p@\lineskip 3\p@
    \let\mb@l\hss\let\mb@r\hss
    \expandafter\let\csname mb@#1\endcsname\relax
    \let\\\@stackcr
    \@ishortstack}

%% 論文
\def\@makePtitle{%
 \parindent\z@
 \setbox\@tempboxa\vbox{%
  \hskip18\@Q
  \output@TypeofDoc
   \hfill\@SCNo\unskip\hskip18\@Q\hbox{}\par
  \nointerlineskip
  \vskip7.5mm
  \bgroup\title@font
   \setbox0\hbox{\shortstack{\@title}}%
   \ifdim\wd0>\hsize
    \parbox{\hsize}{\raggedright
     \@title
     \if@use@subtitle\else
      \ifx\@etitle\empty\else \unskip\nobreak\smash{\@etitlemark}\fi\fi
    }\par
   \else
    \centering
    \jasj@shortstack[l]{\@title
     \if@use@subtitle\else
      \ifx\@etitle\empty\else \unskip\nobreak\smash{\@etitlemark}\fi\fi
    }\par
   \fi
  \egroup
  \ifx\@subtitle\empty\else
   \bgroup\subtitle@font\centering
    \nointerlineskip
    \vskip2.5mm
    \ddash\inhibitglue \@subtitle\inhibitglue\ddash
     \ifx\@etitle\empty\else \unskip\nobreak\smash{\@etitlemark}\fi\par
   \egroup
  \fi
  \nointerlineskip
  \vskip7.5mm
  \bgroup\author@font\centering
   \output@Jauthorlist\par
   \nointerlineskip
   \vskip7.5mm
  \egroup
  \bgroup
   \if@Letter
    \hfill\output@Letterkeywordsbox\par
   \else
    \if@ShortNote
     \hfill\output@SNkeywordsbox\par
    \else
     \hfil\output@abstractbox\par
    \fi
   \fi
  \egroup
 }%
 \@tempdima \ht\@tempboxa
 \advance \@tempdima \dp\@tempboxa
 \@tempdimb \@tempdima
 \divide \@tempdimb \Cvs
 \@tempcnta=\@tempdimb
 \@tempdimb \@tempcnta\Cvs
 \advance \@tempdima -\@tempdimb
 \ifdim \@tempdimb > .5\Cvs
  \advance \@tempcnta \@ne
 \fi
 %%
 \newpage\null
 \boxmaxdepth\z@
 \lineskiplimit\z@
 \lineskip\z@
 \vbox to \@tempcnta\Cvs{%
  \if@ShortNote
   \vskip-\topskip
  \fi
  \box\@tempboxa
 \vss}%
 \vskip\Cvs
 \vskip\BelowTitleSep
}

\def\measure@titleheight{%
 \@tempdima \ht\@tempboxa
 \advance \@tempdima \dp\@tempboxa
 \ifdim\@tempdima<29.4mm
  \@tempdimb29.4mm
  \@tempdimc29.4mm
 \else
  \@tempdimb\@tempdima
  \@tempdimc\@tempdima
 \fi
 \divide \@tempdimc \Cvs
 \@tempcnta=\@tempdimc
 \ifnum\@tempcnta<6\relax
  \@tempcnta6\relax % 最低 6 に
 \else
  \@tempdimc \@tempcnta\Cvs
  \advance \@tempdima -\@tempdimc
  \ifdim \@tempdima > .5\Cvs
   \advance \@tempcnta \@ne
  \fi
 \fi
 \advance \@tempcnta \@ne
}

%% 小特集
\def\@makeFtitle{%
 \parindent\z@
 \setbox\@tempboxa\vbox{%
  \vskip2mm
  \output@TypeofDoc\par
  \nointerlineskip
  \vskip2mm
  \vfil\vfil\vfil
  \bgroup\title@font
   \setbox0\hbox{\shortstack{\@title}}%
   \ifdim\wd0>\hsize
    \parbox{\hsize}{\raggedright
     \@title
     \if@use@subtitle\else
      \ifx\@etitle\empty\else \unskip\nobreak\smash{\LARGE\@etitlemark}\fi\fi
    }\par
   \else
    \centering
    \shortstack[l]{\@title
     \if@use@subtitle\else
      \ifx\@etitle\empty\else \unskip\nobreak\smash{\LARGE\@etitlemark}\fi\fi
    }\par
   \fi
  \egroup
  \ifx\@subtitle\empty\else
   \bgroup\subtitle@font\centering
    \nointerlineskip
    \vskip1.5mm
    \vfil\vfil
    \ddash\inhibitglue\@subtitle\inhibitglue\ddash
     \ifx\@etitle\empty\else \unskip\nobreak\smash{\@etitlemark}\fi\par
   \egroup
  \fi
  \nointerlineskip
  \vskip2mm
  \vfil\vfil\vfil
  \bgroup\author@font
   \output@Aauthorlist\par
  \egroup
  \nointerlineskip
  \vskip1.5mm
 }%
 %%
 \measure@titleheight
 %%
 \newpage\null
 \boxmaxdepth\z@
 \lineskiplimit\z@
 \lineskip\z@
 \vbox to \@tempcnta\Cvs{%
  \hrule height .4mm
  \vbox to \@tempdimb{%
   \unvbox\@tempboxa
  }%
  \hrule height .4mm
  \nointerlineskip
  \vskip2mm
  \hfill{\footnotesize \@SCNo}\par
  \vss
 }%
 \vskip\Cvs
 \vskip\BelowTitleSep
}

\newif\if@jasjconf \@jasjconffalse

%% 音叉 技術プラザ 解説 特別講演 会議報告 研究発表会報告
\def\jasj@Logo{%
 \if@TuningFork %% 音叉
  \jasj@eps{TuningFork.eps}%
 \else
  \if@General %% 総説??
%   \jasj@eps{General.eps}%
  \else
   \if@TechPlaza %% 技術プラザ
    \jasj@eps{TechPlaza.eps}%
   \else
    \if@Review %% 解説 やさしい解説 特別講演 研究発表会報告 会議報告
     \def\解説@Review{解説}
     \def\や解@Review{やさしい解説}
     \def\特講@Review{特別講演}
     \def\研報@Review{研究発表会報告}
     \def\会報@Review{会議報告}
     \ifx\@TypeofReviews\解説@Review
      \jasj@eps{Review.eps}%
     \else
      \ifx\@TypeofReviews\や解@Review
       \jasj@eps{EasyReview.eps}%
      \else
       \ifx\@TypeofReviews\特講@Review
        \jasj@eps{Lecture.eps}%
       \else
        \ifx\@TypeofReviews\研報@Review
         \jasj@eps{Report.eps}%
         \global\@jasjconftrue
        \else
         \ifx\@TypeofReviews\会報@Review
          \jasj@eps{Conference.eps}%
         \else
          \jasj@warning{\string\TypeofReviews{\@TypeofReviews}
           is not supported. see readme.tex}%
         \fi
        \fi
       \fi
      \fi
     \fi
    \else
     %%
    \fi
   \fi
  \fi
 \fi
}

\def\jasj@eps#1{%
 \global\setbox\@tempboxb\hbox{%
  \if@cameraready
   \IfFileExists{/work/jasj/psfile/#1}
    {\scalebox{1}{\includegraphics{/work/jasj/psfile/#1}}}%
    {\pseudo@eps}%
  \else
   \IfFileExists{#1}
    {\scalebox{1}{\includegraphics{#1}}}%
    {\pseudo@eps}%
  \fi
 }%
}

\def\pseudo@eps{%
 \ifx\@TypeofReviews\empty
  \parbox{5zw}{\@Type@fDoc}%
 \else
  \if@TechPlaza
   \parbox{5zw}{\@Type@fDoc}%
  \else
   \if@TuningFork
    \parbox{5zw}{\@Type@fDoc}%
   \else
    \parbox{4zw}{\@TypeofReviews}%
   \fi
  \fi
 \fi
}

%% 技術プラザ 解説 特別講演 会議報告 研究発表会報告
\def\@makeMISCtitle{% 13Q misc
 \parindent\z@
 \setbox\@tempboxa\vbox{\jasj@Logo
  \if@jasjconf
   \let\@fnsymbol\@gobble
  \fi
  \vskip2mm
  \vfil\vfil\vfil
  \bgroup\title@font
   \setbox0\hbox{\shortstack{\@title}}%
   \@tempdimc\hsize
   \advance \@tempdimc -\wd\@tempboxb
   \advance \@tempdimc -2mm
   \ifdim\wd0>\@tempdimc
    \hskip\wd\@tempboxb\hfil
    \parbox{\@tempdimc}{\raggedright
     \@title
     \if@use@subtitle\else
      \ifx\@etitle\empty\else \unskip\nobreak\smash{\LARGE\@etitlemark}\fi\fi
    }\par
   \else
    \hskip\wd\@tempboxb\hfil
    \shortstack[l]{\@title
     \if@use@subtitle\else
      \ifx\@etitle\empty\else \unskip\nobreak\smash{\LARGE\@etitlemark}\fi\fi
    }\par
   \fi
  \egroup
  \ifx\@subtitle\empty\else
   \bgroup\subtitle@font
    \nointerlineskip
    \vskip2mm
    \vfil\vfil
    \hskip\wd\@tempboxb
    \hfil \ddash\inhibitglue\@subtitle\inhibitglue\ddash
     \ifx\@etitle\empty\else \unskip\nobreak\smash{\@etitlemark}\fi\par
   \egroup
  \fi
  \nointerlineskip
  \vskip2mm
  \vfil\vfil\vfil
  \bgroup\author@font
   \output@Aauthorlist\par
  \egroup
  \nointerlineskip
  \vskip1.5mm
 }%
 %%
 \measure@titleheight
 %%
 \newpage\null
 \boxmaxdepth\z@
 \lineskiplimit\z@
 \lineskip\z@
 \vbox to \@tempcnta\Cvs{%
  \hrule height .4mm
  \vbox to \@tempdimb{%
   \vbox to \z@{\vbox to \@tempdimb{\vss \box\@tempboxb\vss}\vss}%
   \unvbox\@tempboxa
  }%
  \hrule height .4mm
  \nointerlineskip
  \vskip2mm
  \hfill{\footnotesize \@SCNo}\par
  \vss
 }%
 \vskip\Cvs
 \vskip\BelowTitleSep
}

%% 音叉
\def\@makeTFtitle{% 14Q TuningFork
 \parindent\z@
 \setbox\@tempboxa\vbox{\jasj@Logo
  \vskip2mm
  \vfil\vfil\vfil
  \bgroup\title@font
   \setbox0\hbox{\shortstack{\@title}}%
   \@tempdimc\hsize
   \advance \@tempdimc -\wd\@tempboxb
   \advance \@tempdimc -20mm % 4(2+2)+16(eps of face)
   \ifdim\wd0>\@tempdimc
    \hskip\wd\@tempboxb\hfil
    \parbox{\@tempdimc}{\raggedright
     \@title
     \if@use@subtitle\else
      \ifx\@etitle\empty\else \unskip\nobreak\smash{\LARGE\@etitlemark}\fi\fi
    }\hspace*{16mm}\par
   \else
    \hskip\wd\@tempboxb\hfil
    \shortstack[l]{\@title
     \if@use@subtitle\else
      \ifx\@etitle\empty\else \unskip\nobreak\smash{\LARGE\@etitlemark}\fi\fi
    }\hspace*{16mm}\par
   \fi
  \egroup
  \ifx\@subtitle\empty\else
   \bgroup\subtitle@font
    \nointerlineskip
    \vskip2mm
    \vfil\vfil
    \hskip\wd\@tempboxb
    \hfil \ddash\inhibitglue\@subtitle\inhibitglue\ddash
     \ifx\@etitle\empty\else \unskip\nobreak\smash{\@etitlemark}\fi\par
   \egroup
  \fi
  \nointerlineskip
  \vskip2mm
  \vfil\vfil\vfil
  \bgroup\author@font
   \output@Aauthorlist\par
  \egroup
  \nointerlineskip
  \vskip1.5mm
  \TuningFork@pic@face
 }%
 %%
 %%\measure@titleheight
 %%
 \newpage\null
 \boxmaxdepth\z@
 \lineskiplimit\z@
 \lineskip\z@
 \vbox to 7\Cvs{%
  \hrule height .4mm
  \vbox to 34.5mm{%
   \vbox to \z@{\vbox to 34.5mm{\vss \box\@tempboxb\vss}\vss}%
   \unvbox\@tempboxa
  }%
  \hrule height .4mm
  \vss
 }%
 \vskip\Cvs
 \vskip\BelowTitleSep
}

\def\TuningFork@pic@face{%
 \vbox to \z@{\vss
  \hbox to \z@{\raise9.5mm\hbox to \hsize{\hss \TF@eps}\hss}%
 }%
}

\def\TF@eps{%
 \IfFileExists{a1.eps}%
  {\resizebox{!}{22mm}{\includegraphics{a1.eps}}}{}%
}

\def\ForewordEps#1{\gdef\@ForewordEps{#1}}
\def\@ForewordEps{}

\def\jasj@face{%
 \global\setbox\@tempboxb\hbox to 26mm{\hss
  \IfFileExists{\@ForewordEps}%
   {\scalebox{1}{\includegraphics{\@ForewordEps}}}%
   {}%
 \hss}%
}

\def\process@FWauthorlist{\global\@alcnt\z@ \@process@FWauthorlist}

\def\@process@FWauthorlist{% 13Q Forword
 \global\advance \@alcnt \@ne
 %%
 \leavevmode
 \@tempcnta\z@
 \ifnum\@alcnt>\@ne\unskip\kern-.15zw ・\allowbreak
  \@tempcnta\@alcnt
  \advance \@tempcnta -\@ne
 \fi
 \expandafter\let\csname @balb0\endcsname\relax
 \csname @balb\number\@tempcnta\endcsname
 %%
   \ifx\al@none\@undefined
    \def\al@none{0}%
   \fi
   \ifnum\al@none=\@alcnt
   \else
    {\footnotesize\bfseries
     \csname @Jafii\number\@alcnt\endcsname\hskip.5zw}%
   \fi
   \csname @JauthornameL\number\@alcnt\endcsname
   \footnotemark[\the\@alcnt]%
 %%
 \ifnum \@alcnt < \total@alcnt \expandafter\@process@FWauthorlist\fi
}

\def\output@FWauthorlist{% 13Q Forword
 \fmt@FWauthorlist
 \setbox\@tempboxa\vbox{\halign{\hfill ##\cr
   \process@FWauthorlist\cr
  }%
 }%
 %%
 \@tempdima\wd\@tempboxa
 \ifdim \@tempdima > \textwidth
  \leavevmode
  \hbox to \textwidth{\leaders\hrule height.12mm\hfil}\par
  \nointerlineskip
  \vskip1.5mm
  \setbox\@tempboxa\hbox{\refmt@FWauthorlist}%
  \raggedleft
  \unhbox\@tempboxa
 \else
  \leavevmode\hfill
  \hbox to \@tempdima{\leaders\hrule height.12mm\hfil}\par
  \nointerlineskip
  \vskip1.5mm
  \leavevmode\hfill
  \box\@tempboxa
 \fi
}

\def\fmt@FWauthorlist{% 13Q Forword
 \@alcnt\z@
 \loop\ifnum \@alcnt < \total@alcnt
  \advance \@alcnt \@ne
  \expandafter\let\csname @JauthornameL\number\@alcnt\endcsname\@empty
  {\combine@Jan}%
 \repeat
}

\def\refmt@FWauthorlist{% 13Q Forword
 \@alcnt\z@
 \loop\ifnum \@alcnt < \total@alcnt
  \advance \@alcnt \@ne
  \expandafter\let\csname @JauthornameL\number\@alcnt\endcsname\@empty
  {\combine@Jan}%
  %%
  \leavevmode
  \ifnum\@alcnt>\@ne\unskip\kern-.15zw ・\allowbreak\fi
  \mbox{%
   \ifnum\al@none=\@alcnt
   \else
    {\footnotesize\bfseries
     \csname @Jafii\number\@alcnt\endcsname\hskip.5zw}%
   \fi
   \csname @JauthornameL\number\@alcnt\endcsname
   \footnotemark[\the\@alcnt]%
  }\kern0pt\ignorespaces
 \repeat
}

%% 巻頭言
\def\@makeFWtitle{% 13Q Foreword
 \parindent\z@
 \setbox\@tempboxa\vbox{\jasj@face
  \vskip2mm
  \vfil\vfil\vfil
  \bgroup\title@font
   \setbox0\hbox{\shortstack{\@title}}%
   \@tempdimc\hsize
   \advance \@tempdimc -\wd\@tempboxb
   \advance \@tempdimc -2mm
   \ifdim\wd0>\@tempdimc
    \hskip\wd\@tempboxb\hfil
    \parbox{\@tempdimc}{\raggedright
     \@title
     \if@use@subtitle\else
      \ifx\@etitle\empty\else \unskip\nobreak\smash{\LARGE\@etitlemark}\fi\fi
    }\par
   \else
    \hskip\wd\@tempboxb\hfil
    \shortstack[l]{\@title
     \if@use@subtitle\else
      \ifx\@etitle\empty\else \unskip\nobreak\smash{\LARGE\@etitlemark}\fi\fi
    }\par
   \fi
  \egroup
  \ifx\@subtitle\empty\else
   \bgroup\subtitle@font
    \nointerlineskip
    \vskip2mm
    \vfil\vfil
    \hskip\wd\@tempboxb
    \hfil \ddash\inhibitglue\@subtitle\inhibitglue\ddash
     \ifx\@etitle\empty\else \unskip\nobreak\smash{\@etitlemark}\fi\par
   \egroup
  \fi
  \nointerlineskip
  \vskip2mm
  \vfil\vfil\vfil
  \bgroup\author@font
   \output@FWauthorlist\par
  \egroup
  \nointerlineskip
  \vskip1.5mm
 }%
 %%
 \measure@titleheight
 %%
 \newpage\null
 \boxmaxdepth\z@
 \lineskiplimit\z@
 \lineskip\z@
 \vbox to \@tempcnta\Cvs{%
  \hrule height .4mm
  \vbox to \@tempdimb{%
   \vbox to \z@{%
    \vbox to \@tempdimb{\vss
     \if@FwdPres\else
      \hbox to \wd\@tempboxb{\hss\subtitle@font 巻　頭　言\hss}%
      \vskip1mm
     \fi
     \box\@tempboxb\vss
     }\vss
   }%
   \unvbox\@tempboxa
  }%
  \hrule height .4mm
  \vss
 }%
%% \vskip\Cvs
 \vskip\BelowTitleSep
}

%% 音叉 技術プラザ 解説 特別講演 会議報告 研究発表会報告
\if@Paper %% 論文
 \let\@maketitle\@makePtitle
\else
 \if@TechnicalReport %% 技術報告
  \let\@maketitle\@makePtitle
 \else
  \if@Letter %% 研究速報
   \let\@maketitle\@makePtitle 
  \else
   \if@General %% 総説??
    \let\@maketitle\@makePtitle % \@makeGtitle
   \else
    \if@ShortNote %% 寄書
     \let\@makeSNtitle\@makePtitle
    \else
     \if@TechPlaza %% 技術プラザ
      \let\@maketitle\@makeMISCtitle % \@makeTPtitle
     \else
      \if@Feature %% 小特集
       \let\@maketitle\@makeFtitle
      \else
       \if@Review %% 解説 やさしい解説 特別講演 研究発表会報告 会議報告
        \let\@maketitle\@makeMISCtitle % \@makeRtitle
       \else
        \if@TuningFork %% 音叉
         \let\@maketitle\@makeTFtitle
        \else
         \if@Foreword %% 巻頭言
          \let\@maketitle\@makeFWtitle
         \else
          \let\@maketitle\@makeMISCtitle
         \fi
        \fi
       \fi
      \fi
     \fi
    \fi
   \fi
  \fi
 \fi
\fi

\setcounter{secnumdepth}{4}
%\newcounter{part}
\newcounter{section}
\newcounter{subsection}[section]
\newcounter{subsubsection}[subsection]
\newcounter{paragraph}[subsubsection]
\newcounter{subparagraph}[paragraph]
%\renewcommand{\thepart}{\@Roman\c@part}
\renewcommand{\thesection}{\@arabic\c@section}
\renewcommand{\thesubsection}{\thesection.\@arabic\c@subsection}
\renewcommand{\thesubsubsection}{%
   \thesubsection.\@arabic\c@subsubsection}
\renewcommand{\theparagraph}{%
 \inhibitglue （\@arabic\c@paragraph ）\inhibitglue}
\renewcommand{\thesubparagraph}{%
   \theparagraph.\@arabic\c@subparagraph}

\def\@afterheading{%
 \global\@nobreaktrue
 \everypar{%
  \if@nobreak
   \global\@nobreakfalse
   \clubpenalty \z@
    \if@afterindent
    \else
     {\setbox\z@=\lastbox}%
    \fi
  \else
   \clubpenalty\@clubpenalty
   \everypar{}%
  \fi}%
}

%% \@startsection{NAME}{LEVEL}{INDENT}{BEFORESKIP}{AFTERSKIP}{STYLE}
\def\@startsection#1#2#3#4#5#6{\if@noskipsec \leavevmode \fi
   \par \@tempskipa #4\relax
   \@afterindenttrue
   \ifdim \@tempskipa <\z@ \@tempskipa -\@tempskipa \@afterindentfalse\fi
   \if@nobreak
    \everypar{}%
   \else
    \addpenalty\@secpenalty
    \ifnum#2=\@ne  %% 1/*/1 or 0.5/*/0.5
     \vskip-\prevdepth \prevdepth\z@ \vskip\Cvs
     \advance\@tempskipa-\Cvs
     \vspace*{\@tempskipa}
    \else
     \vskip-\prevdepth \prevdepth\z@ \vskip\Cvs
      \advance\@tempskipa-\Cvs
      \vspace*{\@tempskipa}
    \fi
   \fi
 \@ifstar{\@ssect{#3}{#4}{#5}{#6}}{\@dblarg{\@sect{#1}{#2}{#3}{#4}{#5}{#6}}}}

%% \@sect{NAME}{LEVEL}{INDENT}{BEFORESKIP}{AFTERSKIP}{STYLE}[ARG1]{ARG2}
\def\@sect#1#2#3#4#5#6[#7]#8{%
 \ifnum #2>\c@secnumdepth
  \let\@svsec\@empty
 \else
  \refstepcounter{#1}%
  \protected@edef\@svsec{\@seccntformat{#1}\relax}%
 \fi
  \@tempskipa #5\relax
  \ifdim \@tempskipa<\z@
   \def\@svsechd{%
     #6{\hskip #3\relax
        \@svsec #8}%
   }%
  \else
   \begingroup
    #6{%
      \sec@fmt{#3}{#8}%
%      \@hangfrom{\hskip #3\relax\@svsec}%
%       \interlinepenalty\@M #8\@@par
      }%
   \endgroup
  \fi
  \@xsect{#5}}

%% \@ssect{INDENT}{BEFORESKIP}{AFTERSKIP}{STYLE}{ARG} ==
\def\@ssect#1#2#3#4#5{%
  \@tempskipa #3\relax
  \ifdim \@tempskipa<\z@
   \def\@svsechd{#4{\hskip #1\relax #5}}%
  \else
   \begingroup
    #4{%
      \ssec@fmt{#1}{#5}%
%       \@hangfrom{\hskip #1}%
%        \interlinepenalty\@M #5\@@par
      }%
   \endgroup
  \fi
  \@xsect{#3}}

\def\@xsect#1{%
  \@tempskipa #1\relax
  \ifdim \@tempskipa<\z@
    \@nobreakfalse
    \global\@noskipsectrue
    \everypar{%
      \if@noskipsec
        \global\@noskipsecfalse
       {\setbox\z@\lastbox}%
        \clubpenalty\@M
        \begingroup \@svsechd \endgroup
        \unskip
        \@tempskipa #1\relax
        \hskip -\@tempskipa
        \pagebreak[2]%
      \else
        \clubpenalty \@clubpenalty
        \everypar{}%
      \fi}%
  \else
    \par \nobreak
    \vskip \@tempskipa
    \@afterheading
  \fi
  \ignorespaces}

\def\@seccntformat#1{{\sffamily\ybaselineshift.5\@EM
 \csname the#1\endcsname\csname dotafter@#1\endcsname}\hskip.75zw}
\def\dotafter@section{.}

\newcount\@tmpfncnt

\def\sec@fmt#1#2{%
 \@tmpfncnt\c@footnote
 \@tempdima#1\relax
 \ifdim\@tempdima=\z@ %% section
  \setbox\@tempboxa\hbox{\@svsec\shortstack{#2}}%
  \c@footnote\@tmpfncnt
  \ifdim \wd\@tempboxa<\hsize
   \setbox\@tempboxb\hbox{#2}%
   \c@footnote\@tmpfncnt
   \ifdim\wd\@tempboxb<4.5zw
    \ifdim\wd\@tempboxb<2zw
     \noindent\hfil
     \@svsec{#2}\@@par
    \else
     \def\@makefnmark{\hbox to \z@{\@textsuperscript{\normalfont
      \@thefnmark}\hss}}%
     \noindent\hfil
     \@svsec\kintou{5zw}{#2}\@@par
    \fi
   \else
    \noindent\hfil
    \parbox{\wd\@tempboxa}{\@hangfrom{\@svsec}#2}\@@par
   \fi
  \else
   \@hangfrom{\hskip #1\relax\@svsec}%
     \interlinepenalty\@M #2\@@par
  \fi
 \else %% subsection etc.
  \setbox\@tempboxb\hbox{#2}%
  \ifdim\wd\@tempboxb<4.5zw
  \c@footnote\@tmpfncnt
   \def\@makefnmark{\hbox to \z@{\@textsuperscript{\normalfont
    \@thefnmark}\hss}}%
   \@hangfrom{\hskip #1\relax\@svsec}%
    \interlinepenalty\@M \kintou{5zw}{#2}\@@par
  \else
   \@hangfrom{\hskip #1\relax\@svsec}%
    \interlinepenalty\@M #2\@@par
  \fi
 \fi
}

\def\ssec@fmt#1#2{%
 \@tmpfncnt\c@footnote
 \@tempdima#1\relax
 \ifdim\@tempdima=\z@ %% section
  \setbox\@tempboxa\hbox{\shortstack{#2}}%
  \c@footnote\@tmpfncnt
  \ifdim \wd\@tempboxa<\hsize
   \setbox\@tempboxb\hbox{#2}%
   \c@footnote\@tmpfncnt
   \ifdim\wd\@tempboxb<4.5zw
    \ifdim\wd\@tempboxb<2zw
     \noindent\hfil
     #2\@@par
    \else
     \def\@makefnmark{\hbox to \z@{\@textsuperscript{\normalfont
      \@thefnmark}\hss}}%
     \noindent\hfil
     \kintou{5zw}{#2}\@@par
    \fi
   \else
    \noindent\hfil
    \parbox{\wd\@tempboxa}{#2}\@@par
   \fi
  \else
   \@hangfrom{\hskip #1}%
     \interlinepenalty\@M #2\@@par
  \fi
 \else %% subsection etc.
  \setbox\@tempboxb\hbox{#2}%
  \ifdim\wd\@tempboxb<4.5zw
  \c@footnote\@tmpfncnt
   \def\@makefnmark{\hbox to \z@{\@textsuperscript{\normalfont
    \@thefnmark}\hss}}%
   \@hangfrom{\hskip #1}%
    \interlinepenalty\@M \kintou{5zw}{#2}\@@par
  \else
   \@hangfrom{\hskip #1}%
    \interlinepenalty\@M #2\@@par
  \fi
 \fi
}

\newcommand{\section}{\@startsection{section}{1}{\z@}%
   {.5\Cvs \@plus.3\Cdp \@minus.1\Cdp}%
   {.5\Cvs \@plus.3\Cdp \@minus.1\Cdp}%
   {\reset@font\sec@font}}
\newcommand{\subsection}{\@startsection{subsection}{2}{1zw}%
   {\z@ \@plus.2\Cdp \@minus.1\Cdp}%
   {\z@ \@plus.2\Cdp \@minus.1\Cdp}%
   {\reset@font\subsec@font}}
\newcommand{\subsubsection}{\@startsection{subsubsection}{3}{1zw}%
   {\z@ \@plus.2\Cdp \@minus.1\Cdp}%
   {\z@ \@plus.2\Cdp \@minus.1\Cdp}%
   {\reset@font\subsubsec@font}}
\newcommand{\paragraph}{\@startsection{paragraph}{4}{1zw}%
   {\z@ \@plus.2\Cdp \@minus.1\Cdp}%
   {\z@ \@plus.2\Cdp \@minus.1\Cdp}%
   {\reset@font\if@xiiQ\small\else\normalsize\fi}}
\newcommand{\subparagraph}{\@startsection{subparagraph}{5}{1zw}%
   {\z@ \@plus.2\Cdp \@minus.1\Cdp}%
   {-1zw}%
   {\reset@font\if@xiiQ\small\else\normalsize\fi\bfseries}}

\if@xivQ
 \def\sec@font{\bfseries\fontsize{15\@JQ}{\Cvs}\selectfont
  \ybaselineshift.75\@EM}
 \def\subsec@font{\bfseries\fontsize{14\@JQ}{\Cvs}\selectfont
  \ybaselineshift.75\@EM}
 \def\subsubsec@font{\bfseries\fontsize{14\@JQ}{\Cvs}\selectfont
  \ybaselineshift.75\@EM}
\else
 \def\sec@font{\bfseries\fontsize{14\@JQ}{\Cvs}\selectfont
  \ybaselineshift.5\@EM}
 \if@xiiQ
  \def\subsec@font{\bfseries\small\baselineskip\Cvs\ybaselineshift.5\@EM}
  \def\subsubsec@font{\bfseries\small\baselineskip\Cvs\ybaselineshift.5\@EM}
 \else
  \def\subsec@font{\bfseries\normalsize\ybaselineshift.5\@EM}
  \def\subsubsec@font{\bfseries\normalsize\ybaselineshift.5\@EM}
 \fi
\fi

\newcommand{\appendix}{\par
 \section*{付録}
 \setcounter{section}{0}%
 \setcounter{subsection}{0}%
 \setcounter{figure}{0}%
 \setcounter{table}{0}%
 \setcounter{equation}{0}%
 \let\dotafter@section\relax
 \renewcommand{\thesection}{A.\@arabic\c@section}%
 \renewcommand{\thefigure}{A.\@arabic\c@figure}%
 \renewcommand{\thetable}{A.\@arabic\c@table}%
 \renewcommand{\theequation}{A.\@arabic\c@equation}%
}

\if@twocolumn
  \setlength\leftmargini {2zw}% 2em
\else
  \setlength\leftmargini {2zw}% 2.5em
\fi
\setlength\leftmarginii  {2zw}% 2.2em
\setlength\leftmarginiii {2zw}% 1.87em
\setlength\leftmarginiv  {2zw}% 1.7em
\if@twocolumn
  \setlength\leftmarginv {1zw}% .5em
  \setlength\leftmarginvi{1zw}% .5em
\else
  \setlength\leftmarginv {1zw}% 1em
  \setlength\leftmarginvi{1zw}% 1em
\fi
\setlength  \labelsep  {1zw}% .5em
\setlength  \labelwidth{\leftmargini}
\addtolength\labelwidth{-\labelsep}
\@beginparpenalty -\@lowpenalty
\@endparpenalty   -\@lowpenalty
\@itempenalty     -\@lowpenalty

\renewcommand{\theenumi}{\@arabic\c@enumi}
\renewcommand{\theenumii}{\@alph\c@enumii}
\renewcommand{\theenumiii}{\@roman\c@enumiii}
\renewcommand{\theenumiv}{\@Alph\c@enumiv}
\newcommand{\labelenumi}{% (
 \theenumi)}
\newcommand{\labelenumii}{% (
 \theenumii)}
\newcommand{\labelenumiii}{% (
 \theenumiii)}
\newcommand{\labelenumiv}{% (
 \theenumiv)}
\renewcommand{\p@enumii}{\theenumi}
\renewcommand{\p@enumiii}{\theenumi(\theenumii)}
\renewcommand{\p@enumiv}{\p@enumiii\theenumiii}

\renewenvironment{enumerate}
  {\ifnum \@enumdepth >\thr@@\@toodeep\else
   \advance\@enumdepth\@ne
   \edef\@enumctr{enum\romannumeral\the\@enumdepth}%
   \list{\csname label\@enumctr\endcsname}{%
         \topsep\z@\partopsep\z@\parsep\z@\itemsep\z@
         \labelwidth1zw
         \labelsep.5zw
         \leftmargin2.5zw
         \listparindent1zw
         \clubpenalty\z@
         \@clubpenalty\clubpenalty
         \widowpenalty\z@
         \usecounter{\@enumctr}%
         \def\makelabel##1{\hss\llap{##1}}}%
   \fi}{\endlist}

\newcommand{\labelitemi}{\leavevmode
 \raise.1zh\hbox to 1zw{\hss \textbullet\hss}}
\newcommand{\labelitemii}{\leavevmode
 \raise.1zh\hbox to 1zw{\hss $\circ$\hss}}
\newcommand{\labelitemiii}{\leavevmode
 \raise.1zh\hbox to 1zw{\hss\textasteriskcentered\hss}}
\newcommand{\labelitemiv}{\leavevmode
 \raise.1zh\hbox to 1zw{\hss\textperiodcentered\hss}}

\renewenvironment{itemize}
  {\ifnum \@itemdepth >3\relax\@toodeep\else
   \advance\@itemdepth\@ne
   \edef\@itemitem{labelitem\romannumeral\the\@itemdepth}%
   \expandafter
   \list{\csname \@itemitem\endcsname}{%
         \topsep\z@\parsep\z@\partopsep\z@\itemsep\z@
         \labelwidth1zw
         \labelsep\z@
         \leftmargin2zw
         \itemindent\z@
         \listparindent1zw
         \clubpenalty\z@
         \@clubpenalty\clubpenalty
         \widowpenalty\z@
         \def\makelabel##1{\hss\llap{##1}}}%
   \fi}{\endlist}% \global\@aftersecfalse

\newenvironment{description}
  {\list{}{%
   \topsep\z@\partopsep\z@\parsep\z@\itemsep\z@
   \leftmargin1zw
   \labelwidth\leftmargin
   \labelsep1zw
   \listparindent1zw
   \advance \labelwidth -\labelsep
   \let\makelabel\descriptionlabel
  }}{\endlist}
\newcommand{\descriptionlabel}[1]{%
  \setbox0\hbox{\normalfont\bfseries #1}%
  \dimen0=\wd0 \dimen1=1zw
  \divide \dimen0 \dimen1
  \multiply \dimen0 \dimen1
  \ifdim \dimen0<\wd0 \advance \dimen0 \dimen1 \fi
  \hbox to \dimen0{\box0 \hfil}\hfil
}

\newskip\@hlskip
\@hlskip=.5\baselineskip \@plus 1mm \@minus .5mm

\newenvironment{verse}
  {\let\\\@centercr
   \list{}{\itemsep\z@
           \topsep\@hlskip\parsep\z@\partopsep\z@
           \itemindent -1zw
           \listparindent\itemindent
           \rightmargin\leftmargin \advance\leftmargin 1zw}%
           \item\relax}{\endlist}

\newenvironment{quotation}
  {\list{}{\listparindent 1zw
           \itemindent\listparindent
           \rightmargin\leftmargin
           \topsep\@hlskip\parsep\z@\partopsep\z@
           }%
           \item\relax}{\endlist}

\newenvironment{quote}
  {\list{}{%
           \topsep\@hlskip\parsep\z@\partopsep\z@
           \rightmargin\leftmargin}%
           \item\relax}{\endlist}

\gdef\tabbing{\lineskip \z@skip\let\>\@rtab\let\<\@ltab\let\=\@settab
     \let\+\@tabplus\let\-\@tabminus\let\`\@tabrj\let\'\@tablab
     \let\\=\@tabcr
     \@hightab\@firsttab
     \global\@nxttabmar\@firsttab
     \dimen\@firsttab\@totalleftmargin
     \global\@tabpush\z@ \global\@rjfieldfalse
     \topsep\@hlskip \parsep\z@\partopsep\z@
     \trivlist \item\relax
     \if@minipage\else\vskip\parskip\fi
     \setbox\@tabfbox\hbox{%
       \rlap{\hskip\@totalleftmargin\indent\the\everypar}}%
     \def\@itemfudge{\box\@tabfbox}%
     \@startline\ignorespaces}

\newdimen\verbatimleftmargin
  \verbatimleftmargin\z@
\newdimen\verbatimbaselineskip
  \verbatimbaselineskip\baselineskip
\def\verbatimsize{\if@xiiQ\small\else\normalsize\fi}

\def\@verbatim{%
 \topsep\@hlskip
 \partopsep\z@\parsep\z@\itemsep\z@
 \trivlist \item\relax
  \if@minipage\else
   \vskip\baselineskip
   \vskip-\verbatimbaselineskip
%  \vskip\parskip
  \fi
  \leftskip\@totalleftmargin
  \if@minipage\else
   \advance \leftskip by \verbatimleftmargin
  \fi
  \rightskip\z@skip
  \parindent\z@\parfillskip\@flushglue\parskip\z@skip
  \@@par
  \@tempswafalse
  \def\par{%
    \if@tempswa
      \leavevmode \null \@@par\penalty\interlinepenalty
    \else
      \@tempswatrue
      \ifhmode\@@par\penalty\interlinepenalty\fi
    \fi}%
  \let\do\@makeother \dospecials
  \obeylines
   \verbatimsize \baselineskip\verbatimbaselineskip
   \verbatim@font \@noligs
  \everypar \expandafter{\the\everypar \unpenalty}%
}

%% \def\verbatim@font{\normalfont\ttfamily}

\newcounter{figure}
\renewcommand{\thefigure}{\@arabic\c@figure}
\def\fps@figure{tbp}
\def\ftype@figure{1}
\def\ext@figure{lof}
\def\fnum@figure{\figurename\thefigure}
\newenvironment{figure}
               {\floatenv\capwidth\hsize
                \abovecaptionskip1mm\belowcaptionskip\z@\@float{figure}}
               {\end@float}
\newenvironment{figure*}
               {\floatenv\capwidth35zw
                \abovecaptionskip1mm\belowcaptionskip\z@\@dblfloat{figure}}
               {\end@dblfloat}
\newcounter{table}
\renewcommand{\thetable}{\@arabic\c@table}
\def\fps@table{tbp}
\def\ftype@table{2}
\def\ext@table{lot}
\def\fnum@table{\tablename\thetable}
\newenvironment{table}
               {\floatenv\capwidth\hsize
                \abovecaptionskip\z@\belowcaptionskip1mm\@float{table}}
               {\end@float}
\newenvironment{table*}
               {\floatenv\capwidth35zw
                \abovecaptionskip\z@\belowcaptionskip1mm\@dblfloat{table}}
               {\end@dblfloat}

\def\@floatboxreset {%
 \reset@font
 \footnotesize\tabcolsep.5zw
 \@setminipage
}

\def\floatenv{%
 \renewcommand{\footnotesize}{%
  \@setfontsize\footnotesize\@viiipt{16\@Q}%
  \abovedisplayskip 6\p@ \@plus2\p@ \@minus4\p@
  \abovedisplayshortskip \z@ \@plus\p@
  \belowdisplayshortskip 3\p@ \@plus\p@ \@minus2\p@
  \def\@listi{\leftmargin\leftmargini
              \topsep 3\p@ \@plus\p@ \@minus\p@
              \parsep 2\p@ \@plus\p@ \@minus\p@
              \itemsep \parsep}%
  \belowdisplayskip \abovedisplayskip}%
 \footnotesize
 \let\center\Center
}

\def\Center{\topsep\z@\partopsep\z@\parsep\z@\itemsep\z@
 \trivlist \centering\item\relax}
\def\endCenter{\endtrivlist}

\long\def\@caption#1[#2]#3{\par
% \addcontentsline{\csname ext@#1\endcsname}{#1}%
%  {\protect\numberline{\csname the#1\endcsname}{\ignorespaces #2}}%
 \begingroup
  \@parboxrestore
  \if@minipage
   \@setminipage
  \fi
   \footnotesize\baselineskip14\@Q
   \@makecaption{\csname fnum@#1\endcsname}{\ignorespaces #3}\par
 \endgroup}

\newlength\abovecaptionskip
\newlength\belowcaptionskip

\newbox\@tempboxb
\newdimen\capwidth
\def\capnum@font{\gtfamily\sffamily}

\long\def\@makecaption#1#2{%
 \vskip\abovecaptionskip
 \setbox\@tempboxa\hbox{%
   \def\@ixstackcr{\@ifnextchar[% ]
    \@istackcr{\cr\hskip1zw\ignorespaces}}%
   \def\@istackcr[#1]{\cr\noalign{\vskip #1}\hskip1zw\ignorespaces}%
  \shortstack[l]{{\capnum@font #1}\hskip1zw #2}}%
 \@tempdima \ht\@tempboxa
 \advance \@tempdima \dp\@tempboxa
 \ifdim \@tempdima > \baselineskip
  \ifdim \wd\@tempboxa > \capwidth
   \centering\parbox[t]{\capwidth}{\hangindent1zw
    {\capnum@font #1}\hskip1zw #2}\par
  \else
   \centering\parbox[t]{\wd\@tempboxa}{\hangindent1zw
    {\capnum@font #1}\hskip1zw #2}\par
  \fi
 \else
  \ifdim \wd\@tempboxa > \capwidth
   \centering\parbox[t]{\capwidth}{\hangindent1zw
    {\capnum@font #1}\hskip1zw #2}\par
  \else
   \hbox to\hsize{\hss\box\@tempboxa\hss}\par
  \fi
 \fi
 \vspace{\belowcaptionskip}%
}

\arraycolsep 5\p@
\tabcolsep .5zw
\arrayrulewidth .12mm
\doublerulesep 2\p@
\tabbingsep \labelsep

\skip\@mpfootins = \skip\footins
\setlength\fboxsep{.5zw}
\setlength\fboxrule{.12mm}

\renewcommand{\theequation}{\@arabic\c@equation}

\if@enablejfam
  \DeclareSymbolFont{mincho}{JY1}{mc}{m}{n}
  \DeclareSymbolFontAlphabet{\mathmc}{mincho}
  \SetSymbolFont{mincho}{bold}{JY1}{gt}{m}{n}
  \DeclareMathAlphabet\mathgt{JY1}{gt}{m}{n}
  \reDeclareMathAlphabet{\mathrm}{\@mathrm}{\@mathmc}
  \reDeclareMathAlphabet{\mathbf}{\@mathbf}{\@mathgt}
  \jfam\symmincho
\else
  \DeclareRobustCommand{\mathmc}{%
    \@latex@error{Command \noexpand\mathmc invalid with\space
       `disablejfam' class option.}\@eha
  }
  \DeclareRobustCommand{\mathgt}{%
    \@latex@error{Command \noexpand\mathgt invalid with\space
       `disablejfam' class option.}\@eha
  }
\fi
\DeclareOldFontCommand{\mc}{\normalfont\mcfamily}{\mathmc}
\DeclareOldFontCommand{\gt}{\normalfont\gtfamily}{\mathgt}
\DeclareOldFontCommand{\rm}{\normalfont\rmfamily}{\mathrm}
\DeclareOldFontCommand{\sf}{\normalfont\sffamily}{\mathsf}
\DeclareOldFontCommand{\tt}{\normalfont\ttfamily}{\mathtt}
\DeclareOldFontCommand{\bf}{\normalfont\bfseries}{\mathbf}
\DeclareOldFontCommand{\it}{\normalfont\itshape}{\mathit}
\DeclareOldFontCommand{\sl}{\normalfont\slshape}{\@nomath\sl}
\DeclareOldFontCommand{\sc}{\normalfont\scshape}{\@nomath\sc}
\DeclareRobustCommand*{\cal}{\@fontswitch\relax\mathcal}
\DeclareRobustCommand*{\mit}{\@fontswitch\relax\mathnormal}

\def\acknowledgments{\par
 \addpenalty{-\@highpenalty}%
 \noindent\hfil
 {\small\bfseries \kintou{5zw}{謝辞}}\par
 \nopagebreak
}

\newdimen\bibindent
\setlength\bibindent{1.5em}
\newcommand{\newblock}{\hskip .11em\@plus.33em\@minus.07em}

\newenvironment{thebibliography}[1]
 {%
  \renewcommand{\section}{\@startsection{section}{1}{\z@}%
   {.5\Cvs \@plus\z@ \@minus.1\Cdp}%
   {.5\Cvs \@plus\z@ \@minus.1\Cdp}%
   {\reset@font\bfseries\footnotesize}}%
  \section*{\refname}%
  \footnotesize\baselineskip13\@Q
  %%
  \afterassignment\remove@to@nnil
   \count@ 0#1\relax\@nnil
  \ifnum\count@=\z@
   \global\def\twoorthree@digits##1{%
    \setbox0\hbox{99}\hbox to \wd0{\hss ##1\hss}}%
  \else
   \ifnum#1>99\relax
    \global\def\twoorthree@digits##1{%
     \setbox0\hbox{999}\hbox to \wd0{\hss ##1\hss}}%
   \else
    \global\def\twoorthree@digits##1{%
     \setbox0\hbox{99}\hbox to \wd0{\hss ##1\hss}}%
   \fi
  \fi
  %%
   \list{\@biblabel{\@arabic\c@enumiv}}%
        {%
         \topsep\z@\partopsep\z@\parsep\z@\itemsep\z@\parskip\z@
         \settowidth\labelwidth{\@biblabel{#1}}%
         \leftmargin1zw
         \labelsep1zw
         \itemindent\labelwidth
         \@openbib@code
         \usecounter{enumiv}%
         \let\p@enumiv\@empty
         \renewcommand\theenumiv{\@arabic\c@enumiv}}%
   \sloppy
   \clubpenalty\z@
   \@clubpenalty\clubpenalty
   \widowpenalty\z@
   \sfcode`\.\@m}
  {\def\@noitemerr
    {\@latex@warning{Empty `thebibliography' environment}}%
   \endlist}
\def\@biblabel#1{[\twoorthree@digits{#1}]}
\let\@openbib@code\@empty

\newenvironment{biography}{\par
 \nointerlineskip
 \vskip7mm
 \footnotesize\baselineskip13\@Q
 }{\par}

\def\profile{\@ifstar{\n@profile}{\@profile}}

\def\@profilecheck#1{%
 \@temptokena{#1}%
 \def\hold@name{\the\@temptokena\unskip}%
 \chk@name{\the\@temptokena}%
  \setbox\@tempboxa\hbox{\get@oneword}%
  \ifdim \wd\@tempboxa<1zw
   \let\fmt@name\hold@name
  \else
   \setbox\@tempboxa\hbox{\spaceskip100mm \hold@name}%
   \ifdim \wd\@tempboxa < 100mm
    \jasj@warning{profile "#1" doesn't have a space}%
    \let\fmt@name\hold@name
   \else
    \setbox\@tempboxa\hbox{\hold@name}%
    \ifdim \wd\@tempboxa < 5zw
     \def\fmt@name{\hbox to 5zw{\spaceskip1zw plus 1fil \hold@name}}%
    \else
     \def\@authornamesep{}%
     \expandafter\ifcat\get@oneword ア%
      \def\@authornamesep{\hskip.5zw}%
%%    \def\@authornamesep{・}%
     \fi
     \def\tmp@name##1 ##2\@nil{##1\@authornamesep ##2}%
     \edef\fmt@name{\expandafter\tmp@name\the\@temptokena\@nil\unskip}%
    \fi
   \fi
  \fi
}

\def\profile@font{\small\bfseries}
\newcount\c@profile

\long\def\@profile#1#2{%
 \advance \c@profile \@ne
 \@profilecheck{#1}%
 \parindent\z@
 \setbox\@tempboxa\hbox{\parbox[t]{\hsize}{\baselineskip13\@Q
  \if@xiiQ
   \parshape=10
    21mm 51mm 21mm 51mm 21mm 51mm 21mm 51mm 21mm 51mm
    21mm 51mm 21mm 51mm 21mm 51mm 21mm 51mm \z@ \hsize
  \else
   \parshape=10
    21mm 50.5mm 21mm 50.5mm 21mm 50.5mm 21mm 50.5mm 21mm 50.5mm
    21mm 50.5mm 21mm 50.5mm 21mm 50.5mm 21mm 50.5mm \z@ \hsize
  \fi
   \leavevmode
   {\profile@font \fmt@name}\vspace{1.25mm}\hfil\break
    \hspace*{1zw}\ignorespaces #2\inhibitglue
 }}%
 \@tempdima\ht\@tempboxa \advance \@tempdima \dp\@tempboxa
 \output@profile
}

\long\def\n@profile#1#2{%
 \@profilecheck{#1}%
 \noindent
 {\profile@font \fmt@name}\vspace{1.25mm}\hfil\break
  \hspace*{1zw}\ignorespaces #2\inhibitglue\par
  \nointerlineskip
  \vskip8.5mm
}

\def\output@profile{%
 \ifdim \@tempdima < 27mm
  \vtop to 26mm{%
   \leavevmode\smash{\rlap{\profile@box}}%
    \hbox to \hsize{\hss\box\@tempboxa\hss}\vss
  }\par
 \else
  \leavevmode\smash{\rlap{\profile@box}}%
   \hbox to \hsize{\hss\box\@tempboxa\hss}\par
 \fi
 \nointerlineskip
 \vskip5.5mm
}

\ifx\pdfpageheight\@undefined
 \def\jasj@in@ext{eps}
\else
 \def\jasj@in@ext{pdf}
\fi

\def\profile@box{%
 \IfFileExists{a\the\c@profile.\jasj@in@ext}%
  {\lower23.75mm\hbox{%
    \resizebox{20mm}{26mm}{\includegraphics{a\the\c@profile.\jasj@in@ext}}}%
  }{\line@p@box}%
}

\def\line@p@box{%
 \lower23.75mm
 \vbox to 26mm{\hrule height .1mm
  \hbox to 20mm{%
   \vrule width .1mm height 25.8mm
    \hss
   \vrule width .1mm height 25.8mm}%
 \hrule height .1mm}%
}

\renewcommand{\footnoterule}{%
  \kern-3\p@
  \hrule width \columnwidth
  \kern 2.6\p@}
%\@addtoreset{footnote}{page}
\def\@makefnmark{\hbox{\@textsuperscript{\normalfont\@thefnmark}}}
\newcommand\@makefntext[1]{%
 \clubpenalty\@M
 \widowpenalty\@M
 \everypar{\hangindent1zw}%
 \parindent2zw
 \noindent\hbox to 1zw{\hss\@makefnmark}#1}

\def\@eqnnum{{\normalfont \normalcolor (\theequation)\hspace*{1zw}}}

\def\jasj@InListEnv{%
 \ifdim\topsep=\z@
  \@listi
 \fi
}

%% from fleqn.clo
%%   /usr/local/teTeX/share/texmf/tex/latex/base/fleqn.clo
\ProvidesFile{fleqn.clo}
        [1998/08/17 v1.1c Standard LaTeX option
                                   (flush left equations)]
\newdimen\mathindent
\AtEndOfClass{\mathindent2zw}% 2zw
\renewcommand\[{\relax
                \ifmmode\@badmath
                \else
                  \jasj@InListEnv
                  \begin{trivlist}%
                    \@beginparpenalty\predisplaypenalty
                    \@endparpenalty\postdisplaypenalty
                    \item[]\leavevmode
                    \hb@xt@\linewidth\bgroup $\m@th\displaystyle %$
                      \hskip\mathindent\bgroup
                \fi}
\renewcommand\]{\relax
                \ifmmode
                      \egroup $\hfil% $
                    \egroup
                  \end{trivlist}%
                \else \@badmath
                \fi}
\renewenvironment{equation}%
    {\@beginparpenalty\predisplaypenalty
     \@endparpenalty\postdisplaypenalty
     \refstepcounter{equation}%
     \jasj@InListEnv
     \trivlist \item[]\leavevmode
       \hb@xt@\linewidth\bgroup $\m@th% $
         \displaystyle
         \hskip\mathindent}%
        {$\hfil % $
         \displaywidth\linewidth\hbox{\@eqnnum}%
       \egroup
     \endtrivlist}
\renewenvironment{eqnarray}{%
    \stepcounter{equation}%
    \def\@currentlabel{\p@equation\theequation}%
    \global\@eqnswtrue\m@th
    \global\@eqcnt\z@
    \tabskip\mathindent
    \let\\=\@eqncr
    \jasj@InListEnv
    \setlength\abovedisplayskip{\topsep}%
    \ifvmode
      \addtolength\abovedisplayskip{\partopsep}%
    \fi
    \addtolength\abovedisplayskip{\parskip}%
    \setlength\belowdisplayskip{\abovedisplayskip}%
    \setlength\belowdisplayshortskip{\abovedisplayskip}%
    \setlength\abovedisplayshortskip{\abovedisplayskip}%
    $$\everycr{}\halign to\linewidth% $$
    \bgroup
      \hskip\@centering
      $\displaystyle\tabskip\z@skip{##}$\@eqnsel&%
      \global\@eqcnt\@ne \hskip.8\arraycolsep \hfil${##}$\hfil&%
      \global\@eqcnt\tw@ \hskip.8\arraycolsep
        $\displaystyle{##}$\hfil \tabskip\@centering&%
      \global\@eqcnt\thr@@
        \hb@xt@\z@\bgroup\hss##\egroup\tabskip\z@skip\cr}%
      {\@@eqncr
    \egroup
    \global\advance\c@equation\m@ne$$% $$
    \@ignoretrue
    }
%\endinput

\def\@begintheorem#1#2{%
 \topsep.5\baselineskip\parsep\z@\partopsep\z@\itemsep\z@\labelsep1zw
 \trivlist
   \item[\hskip \labelsep{\bfseries #1\ #2}]}% \itshape
\def\@opargbegintheorem#1#2#3{%
 \topsep.5\baselineskip\parsep\z@\partopsep\z@\itemsep\z@\labelsep1zw
 \trivlist
   \item[\hskip \labelsep{\bfseries #1\ #2\ (#3)}]}% \itshape
\def\@endtheorem{\endtrivlist}

\newif\if西暦 \西暦false
\def\西暦{\西暦true}
\def\和暦{\西暦false}
\newcount\heisei \heisei\year \advance\heisei-1988\relax
\def\today{{%
  \iftdir
    \if西暦
      \kansuji\number\year 年
      \kansuji\number\month 月
      \kansuji\number\day 日
    \else
      平成\ifnum\heisei=1 元年\else\kansuji\number\heisei 年\fi
      \kansuji\number\month 月
      \kansuji\number\day 日
    \fi
  \else
    \if西暦
      \number\year~年
      \number\month~月
      \number\day~日
    \else
      平成\ifnum\heisei=1 元年\else\number\heisei~年\fi
      \number\month~月
      \number\day~日
    \fi
  \fi}}

%\newcommand{\prepartname}{第}
%\newcommand{\postpartname}{部}
%\newcommand{\contentsname}{目 次}
%\newcommand{\listfigurename}{図 目 次}
%\newcommand{\listtablename}{表 目 次}
\newcommand{\refname}{文献}
%\newcommand{\indexname}{索 引}
\newcommand{\figurename}{図--}
\newcommand{\tablename}{表--}
%\newcommand{\appendixname}{付 録}
%\newcommand{\abstractname}{概 要}

%%## citesort.sty ##%%
\newcount\@minsofar
\newcount\@min
\newcount\@cite@temp
\def\@citex[#1]#2{%
\if@filesw \immediate \write \@auxout {\string \citation {#2}}\fi
\@tempcntb\m@ne \let\@h@ld\relax \def\@citea{}%
\@min\m@ne%
\@cite{%
  \@for \@citeb:=#2\do {\@ifundefined {b@\@citeb}%
    {\@h@ld\@citea\@tempcntb\m@ne{\bfseries ?}%
    \@warning {Citation `\@citeb ' on page \thepage \space undefined}}%
{\@minsofar\z@ \@for \@scan@cites:=#2\do {%
  \@ifundefined{b@\@scan@cites}%
    {\@cite@temp\m@ne}
    {\@cite@temp\number\csname b@\@scan@cites \endcsname \relax}%
\ifnum\@cite@temp > \@min% select the next one to list
    \ifnum\@minsofar = \z@
      \@minsofar\number\@cite@temp
      \edef\@scan@copy{\@scan@cites}\else
    \ifnum\@cite@temp < \@minsofar
      \@minsofar\number\@cite@temp
      \edef\@scan@copy{\@scan@cites}\fi\fi\fi}\@tempcnta\@min
  \ifnum\@minsofar > \z@ % some more
    \advance\@tempcnta\@ne
    \@min\@minsofar
    \ifnum\@tempcnta=\@minsofar %   Number follows previous--hold on to it
      \ifx\@h@ld\relax
        \edef \@h@ld{\@citea\csname b@\@scan@copy\endcsname}%
      \else \edef\@h@ld{\ifmmode{-}\else--\fi\csname b@\@scan@copy\endcsname}%
      \fi
    \else \@h@ld\@citea\csname b@\@scan@copy\endcsname
          \let\@h@ld\relax
  \fi % no more
\fi}%
\def\@citea{,\penalty\@highpenalty\,}}\@h@ld}{#1}}

%% from "cite.sty", with a little modified
\def\@cite#1#2{\leavevmode %% \unskip
  \ifnum\lastpenalty=\z@\penalty\@highpenalty\fi % highpenalty before
  [{\multiply\@highpenalty 3 #1%             % triple-highpenalties within
      \if@tempswa,\penalty\@highpenalty\ #2\fi % and before note.
    }]\spacefactor\@m}
%% end of cite.sty

\let\org@cite\@cite
\def\cite{\@ifnextchar[% ]
 {\@tempswatrue\let\@cite\org@cite\@citex}
 {\@tempswafalse\let\@cite\org@cite\@citex[]}}

\if@NTT\else
 \postbreakpenalty`（=10000
 \prebreakpenalty`）=10000
 \postbreakpenalty`［=10000
 \prebreakpenalty`］=10000
 \postbreakpenalty`〈=10000
 \prebreakpenalty`〉=10000
 \prebreakpenalty`"=10000
 \prebreakpenalty`℃=10000
 \prebreakpenalty`　=10000
 \prebreakpenalty`・=10000
 \prebreakpenalty`〜=10000
 \prebreakpenalty`ー=10000
 \prebreakpenalty`？=10000
 \prebreakpenalty`！=10000
 \postbreakpenalty"5C=10000
\fi

%% <local definitions>
\def\figref{\@ifstar
 {\nf@figref}{\bf@figref}}
\def\bf@figref#1{%
 \@ifundefined{BF@#1}%
  {\expandafter\def\csname BF@#1\endcsname{}%
   \leavevmode
   {\gtfamily\sffamily \figurename\nobreak\ref{#1}}}%
  {\figurename\nobreak\ref{#1}}%
}
\def\nf@figref#1{\figurename\nobreak\ref{#1}}

\def\tabref{\@ifstar
 {\nf@tabref}{\bf@tabref}}
\def\bf@tabref#1{%
 \@ifundefined{BF@#1}%
  {\expandafter\def\csname BF@#1\endcsname{}%
   \leavevmode
   {\gtfamily\sffamily \tablename\nobreak\ref{#1}}}%
  {\tablename\nobreak\ref{#1}}%
}
\def\nf@tabref#1{\tablename\nobreak\ref{#1}}

\def\onelineskip{\par\vspace{1\baselineskip}\par}
\def\halflineskip{\par\vspace{.5\baselineskip}\par}

\def\ddash{\penalty\@M\leavevmode
 \setbox0\hbox{------}%
 \ifdim\wd0>2zw
  \raise.1zh\hbox to 2zw{---\hss ---}%
 \else
  \raise.1zh\hbox to 2zw{\hss ---\kern-.01ex ---\hss}%
 \fi
}
\def\zdash{\penalty\@M\leavevmode\raise.1zh\hbox{---}}
\def\hdash{\penalty\@M\leavevmode\raise.1zh\hbox{--}}
\def\MARU#1{\raisebox{0.1zh}%
 {{\normalfont\ooalign{\hfil\lower.168ex\hbox{#1}\hfil\crcr\mathhexbox20D}}}}
\def\FRAC#1#2{\leavevmode\kern-.1em
  \raise.5ex\hbox{\the\scriptfont0 #1}\kern-.1em
  /\kern-.15em\lower.25ex\hbox{\the\scriptfont0 #2}}
\def\kintou#1#2{%
 \leavevmode\hbox to #1{%
  \kanjiskip\z@ plus 1fill minus 1fill\xkanjiskip\kanjiskip #2\hfil}}
\def\ruby#1#2{\leavevmode \setbox0=\hbox{#1}\setbox1=\hbox{\tiny#2}%
 \ifdim\wd0>\wd1 \dimen0=\wd0 \else \dimen0=\wd1 \fi
 \hbox{\kanjiskip=\fill
  \vbox{\hbox to \dimen0{\tiny \hfil#2\hfil}%
  \nointerlineskip \hbox to \dimen0{\hfil#1\hfil}}}}
\def\RN#1{\uppercase\expandafter{\romannumeral#1}}
\def\QED{{\unskip\nobreak\hfil\penalty50
 \hskip1zw\hbox{}\nobreak\hfil \hbox{$\Box$\hskip1zw}
 \parfillskip\z@ \finalhyphendemerits\z@\par}}

\def\Hline{\noalign{\hrule height .3mm}}
%% </local definitions>

\def\sloppy{\tolerance9999\hbadness9999\hfuzz.5\p@ \vfuzz.5\p@}

\hbadness4000
\vbadness10001
\tolerance4000\pretolerance\m@ne
\clubpenalty\z@
\widowpenalty\z@
\displaywidowpenalty\z@
\interdisplaylinepenalty\z@ % 100
\predisplaypenalty\z@       % 1000

\AtBeginDocument{%
 \@ifundefined{maketag@@@}{}
  {%
   \@mathmargin2zw \@plus\z@ \@minus\z@
   \multlinegap2zw
   \def\maketag@@@#1{\hbox{\m@th\normalfont #1}\hskip1zw}%
   \def\eqref#1{\textup{\tagform@{\ref{#1}}\unskip}}%
  }%
 \if@xiiQ
  \small
 \else
  \if@xivQ
   \fontsize{14\@JQ}{21\@Q}\selectfont
  \fi
 \fi
}

\AtEndDocument{%
 \immediate\write\@auxout
  {\string\newlabel{jasj@lastpage}{{\@currentlabel}{\thepage}}}%
}

\if@MemWr
 \thispagestyle{MemWr@plain}
 \pagestyle{MemWr@jasj}
\else
 \pagestyle{jasj}
\fi
\pagenumbering{arabic}
\raggedbottom
\if@twocolumn
  \twocolumn
  \sloppy
  \flushbottom
\else
  \onecolumn
\fi
\if@twoside
  \@mparswitchtrue
\else
  \@mparswitchfalse
\fi

\endinput
